/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.source;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.ObjectUtils;
import org.sonar.api.utils.System2;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.ce.task.projectanalysis.scm.Changeset;
import org.sonar.ce.task.projectanalysis.source.FileSourceDataComputer;
import org.sonar.ce.task.projectanalysis.source.FileSourceDataWarnings;
import org.sonar.ce.task.projectanalysis.source.SourceLinesHashRepository;
import org.sonar.ce.task.step.ComputationStep;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.protobuf.DbFileSources;
import org.sonar.db.source.FileSourceDto;

public class PersistFileSourcesStep
implements ComputationStep {
    private final DbClient dbClient;
    private final System2 system2;
    private final TreeRootHolder treeRootHolder;
    private final SourceLinesHashRepository sourceLinesHash;
    private final FileSourceDataComputer fileSourceDataComputer;
    private final FileSourceDataWarnings fileSourceDataWarnings;

    public PersistFileSourcesStep(DbClient dbClient, System2 system2, TreeRootHolder treeRootHolder, SourceLinesHashRepository sourceLinesHash, FileSourceDataComputer fileSourceDataComputer, FileSourceDataWarnings fileSourceDataWarnings) {
        this.dbClient = dbClient;
        this.system2 = system2;
        this.treeRootHolder = treeRootHolder;
        this.sourceLinesHash = sourceLinesHash;
        this.fileSourceDataComputer = fileSourceDataComputer;
        this.fileSourceDataWarnings = fileSourceDataWarnings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ComputationStep.Context context) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            new DepthTraversalTypeAwareCrawler(new FileSourceVisitor(dbSession)).visit(this.treeRootHolder.getRoot());
        }
        finally {
            this.fileSourceDataWarnings.commitWarnings();
        }
    }

    public String getDescription() {
        return "Persist sources";
    }

    private class FileSourceVisitor
    extends TypeAwareVisitorAdapter {
        private final DbSession session;
        private Map<String, FileSourceDto> previousFileSourcesByUuid;
        private String projectUuid;

        private FileSourceVisitor(DbSession session) {
            super(CrawlerDepthLimit.FILE, ComponentVisitor.Order.PRE_ORDER);
            this.previousFileSourcesByUuid = new HashMap<String, FileSourceDto>();
            this.session = session;
        }

        @Override
        public void visitProject(Component project) {
            this.projectUuid = project.getUuid();
            this.session.select("org.sonar.db.source.FileSourceMapper.selectHashesForProject", (Object)ImmutableMap.of((Object)"projectUuid", (Object)this.projectUuid), context -> {
                FileSourceDto dto = (FileSourceDto)context.getResultObject();
                this.previousFileSourcesByUuid.put(dto.getFileUuid(), dto);
            });
        }

        @Override
        public void visitFile(Component file) {
            try {
                FileSourceDataComputer.Data fileSourceData = PersistFileSourcesStep.this.fileSourceDataComputer.compute(file, PersistFileSourcesStep.this.fileSourceDataWarnings);
                this.persistSource(fileSourceData, file);
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Cannot persist sources of %s", file.getDbKey()), e);
            }
        }

        private void persistSource(FileSourceDataComputer.Data fileSourceData, Component file) {
            DbFileSources.Data lineData = fileSourceData.getLineData();
            byte[] binaryData = FileSourceDto.encodeSourceData((DbFileSources.Data)lineData);
            String dataHash = DigestUtils.md5Hex((byte[])binaryData);
            String srcHash = fileSourceData.getSrcHash();
            List<String> lineHashes = fileSourceData.getLineHashes();
            Changeset latestChangeWithRevision = fileSourceData.getLatestChangeWithRevision();
            int lineHashesVersion = PersistFileSourcesStep.this.sourceLinesHash.getLineHashesVersion(file);
            FileSourceDto previousDto = this.previousFileSourcesByUuid.get(file.getUuid());
            if (previousDto == null) {
                FileSourceDto dto = new FileSourceDto().setProjectUuid(this.projectUuid).setFileUuid(file.getUuid()).setBinaryData(binaryData).setSrcHash(srcHash).setDataHash(dataHash).setLineHashes(lineHashes).setLineHashesVersion(lineHashesVersion).setCreatedAt(PersistFileSourcesStep.this.system2.now()).setUpdatedAt(PersistFileSourcesStep.this.system2.now()).setRevision(this.computeRevision(latestChangeWithRevision));
                PersistFileSourcesStep.this.dbClient.fileSourceDao().insert(this.session, dto);
                this.session.commit();
            } else {
                boolean lineHashesVersionUpdated;
                boolean binaryDataUpdated = !dataHash.equals(previousDto.getDataHash());
                boolean srcHashUpdated = !srcHash.equals(previousDto.getSrcHash());
                String revision = this.computeRevision(latestChangeWithRevision);
                boolean revisionUpdated = !ObjectUtils.equals((Object)revision, (Object)previousDto.getRevision());
                boolean bl = lineHashesVersionUpdated = previousDto.getLineHashesVersion() != lineHashesVersion;
                if (binaryDataUpdated || srcHashUpdated || revisionUpdated || lineHashesVersionUpdated) {
                    previousDto.setBinaryData(binaryData).setDataHash(dataHash).setSrcHash(srcHash).setLineHashes(lineHashes).setLineHashesVersion(lineHashesVersion).setRevision(revision).setUpdatedAt(PersistFileSourcesStep.this.system2.now());
                    PersistFileSourcesStep.this.dbClient.fileSourceDao().update(this.session, previousDto);
                    this.session.commit();
                }
            }
        }

        @CheckForNull
        private String computeRevision(@Nullable Changeset latestChangeWithRevision) {
            if (latestChangeWithRevision == null) {
                return null;
            }
            return latestChangeWithRevision.getRevision();
        }
    }
}

