/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.source;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.source.SourceHashRepository;
import org.sonar.ce.task.projectanalysis.source.SourceLinesRepository;
import org.sonar.core.hash.SourceHashComputer;
import org.sonar.core.util.CloseableIterator;

public class SourceHashRepositoryImpl
implements SourceHashRepository {
    private static final String SOURCE_OR_HASH_FAILURE_ERROR_MSG = "Failed to read source and compute hashes for component %s";
    private final SourceLinesRepository sourceLinesRepository;
    private final Map<String, String> rawSourceHashesByKey = new HashMap<String, String>();

    public SourceHashRepositoryImpl(SourceLinesRepository sourceLinesRepository) {
        this.sourceLinesRepository = sourceLinesRepository;
    }

    @Override
    public String getRawSourceHash(Component file) {
        SourceHashRepositoryImpl.checkComponentArgument(file);
        if (this.rawSourceHashesByKey.containsKey(file.getDbKey())) {
            return SourceHashRepositoryImpl.checkSourceHash(file.getDbKey(), this.rawSourceHashesByKey.get(file.getDbKey()));
        }
        String newSourceHash = this.computeRawSourceHash(file);
        this.rawSourceHashesByKey.put(file.getDbKey(), newSourceHash);
        return SourceHashRepositoryImpl.checkSourceHash(file.getDbKey(), newSourceHash);
    }

    private static void checkComponentArgument(Component file) {
        Objects.requireNonNull(file, "Specified component can not be null");
        Preconditions.checkArgument((file.getType() == Component.Type.FILE ? 1 : 0) != 0, (String)"File source information can only be retrieved from FILE components (got %s)", (Object[])new Object[]{file.getType()});
    }

    private String computeRawSourceHash(Component file) {
        SourceHashComputer sourceHashComputer = new SourceHashComputer();
        try (CloseableIterator<String> linesIterator = this.sourceLinesRepository.readLines(file);){
            while (linesIterator.hasNext()) {
                sourceHashComputer.addLine((String)linesIterator.next(), linesIterator.hasNext());
            }
            String string = sourceHashComputer.getHash();
            return string;
        }
    }

    private static String checkSourceHash(String fileKey, @Nullable String newSourceHash) {
        Preconditions.checkState((newSourceHash != null ? 1 : 0) != 0, (String)SOURCE_OR_HASH_FAILURE_ERROR_MSG, (Object[])new Object[]{fileKey});
        return newSourceHash;
    }
}

