/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.source;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.sonar.api.utils.TempFolder;
import org.sonar.ce.task.projectanalysis.component.Component;

public class SourceLinesHashCache {
    private static final String FILE_NAME_PREFIX = "hashes-";
    private final Path cacheDirectoryPath;
    private final Set<Integer> cacheFileIds = new HashSet<Integer>();

    public SourceLinesHashCache(TempFolder tempFolder) {
        this.cacheDirectoryPath = tempFolder.newDir().toPath();
    }

    public List<String> computeIfAbsent(Component component, Function<Component, List<String>> hashesComputer) {
        int ref = SourceLinesHashCache.getId(component);
        if (this.cacheFileIds.add(ref)) {
            List<String> hashes = hashesComputer.apply(component);
            this.save(ref, hashes);
            return hashes;
        }
        return this.load(ref);
    }

    public List<String> get(Component component) {
        Preconditions.checkState((boolean)this.contains(component), (String)"Source line hashes for component %s not cached", (Object[])new Object[]{component});
        return this.load(SourceLinesHashCache.getId(component));
    }

    public boolean contains(Component component) {
        return this.cacheFileIds.contains(SourceLinesHashCache.getId(component));
    }

    private static int getId(Component component) {
        return component.getReportAttributes().getRef();
    }

    private void save(int fileId, List<String> hashes) {
        Path filePath = this.getFilePath(fileId);
        try {
            Files.write(filePath, hashes, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Failed to write to '%s'", filePath), e);
        }
    }

    private List<String> load(int fileId) {
        Path filePath = this.getFilePath(fileId);
        try {
            return Files.readAllLines(filePath, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Failed to read '%s'", filePath), e);
        }
    }

    private Path getFilePath(int fileId) {
        return this.cacheDirectoryPath.resolve(FILE_NAME_PREFIX + fileId);
    }
}

