/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import com.google.common.collect.ImmutableSet;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.CheckForNull;
import org.sonar.api.notifications.Notification;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.Duration;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.analysis.Branch;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.projectanalysis.issue.IssueCache;
import org.sonar.ce.task.projectanalysis.notification.NotificationFactory;
import org.sonar.ce.task.step.ComputationStep;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.util.CloseableIterator;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.BranchType;
import org.sonar.db.user.UserDto;
import org.sonar.server.issue.notification.IssuesChangesNotification;
import org.sonar.server.issue.notification.MyNewIssuesNotification;
import org.sonar.server.issue.notification.NewIssuesNotification;
import org.sonar.server.issue.notification.NewIssuesStatistics;
import org.sonar.server.notification.NotificationService;

public class SendIssueNotificationsStep
implements ComputationStep {
    static final Set<Class<? extends Notification>> NOTIF_TYPES = ImmutableSet.of(NewIssuesNotification.class, MyNewIssuesNotification.class, IssuesChangesNotification.class);
    private final IssueCache issueCache;
    private final TreeRootHolder treeRootHolder;
    private final NotificationService service;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final NotificationFactory notificationFactory;
    private final DbClient dbClient;
    private Map<String, Component> componentsByDbKey;

    public SendIssueNotificationsStep(IssueCache issueCache, TreeRootHolder treeRootHolder, NotificationService service, AnalysisMetadataHolder analysisMetadataHolder, NotificationFactory notificationFactory, DbClient dbClient) {
        this.issueCache = issueCache;
        this.treeRootHolder = treeRootHolder;
        this.service = service;
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.notificationFactory = notificationFactory;
        this.dbClient = dbClient;
    }

    public void execute(ComputationStep.Context context) {
        BranchType branchType = this.analysisMetadataHolder.getBranch().getType();
        if (branchType == BranchType.PULL_REQUEST || branchType == BranchType.SHORT) {
            return;
        }
        Component project = this.treeRootHolder.getRoot();
        NotificationStatistics notificationStatistics = new NotificationStatistics();
        if (this.service.hasProjectSubscribersForTypes(this.analysisMetadataHolder.getProject().getUuid(), NOTIF_TYPES)) {
            this.doExecute(notificationStatistics, project);
        }
        notificationStatistics.dumpTo(context);
    }

    private void doExecute(NotificationStatistics notificationStatistics, Component project) {
        Map<String, UserDto> assigneesByUuid;
        long analysisDate = this.analysisMetadataHolder.getAnalysisDate();
        Predicate<DefaultIssue> isOnLeakPredicate = i -> i.isNew() && i.creationDate().getTime() >= SendIssueNotificationsStep.truncateToSeconds(analysisDate);
        NewIssuesStatistics newIssuesStats = new NewIssuesStatistics(isOnLeakPredicate);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Iterable iterable = this.issueCache::traverse;
            Set assigneeUuids = StreamSupport.stream(iterable.spliterator(), false).map(DefaultIssue::assignee).filter(Objects::nonNull).collect(Collectors.toSet());
            assigneesByUuid = this.dbClient.userDao().selectByUuids(dbSession, assigneeUuids).stream().collect(Collectors.toMap(UserDto::getUuid, dto -> dto));
        }
        try (CloseableIterator issues = this.issueCache.traverse();){
            this.processIssues(newIssuesStats, issues, assigneesByUuid, notificationStatistics);
        }
        if (newIssuesStats.hasIssuesOnLeak()) {
            this.sendNewIssuesNotification(newIssuesStats, project, assigneesByUuid, analysisDate, notificationStatistics);
            this.sendMyNewIssuesNotification(newIssuesStats, project, assigneesByUuid, analysisDate, notificationStatistics);
        }
    }

    private static long truncateToSeconds(long analysisDate) {
        Instant instant = new Date(analysisDate).toInstant();
        instant = instant.truncatedTo(ChronoUnit.SECONDS);
        return Date.from(instant).getTime();
    }

    private void processIssues(NewIssuesStatistics newIssuesStats, CloseableIterator<DefaultIssue> issues, Map<String, UserDto> assigneesByUuid, NotificationStatistics notificationStatistics) {
        int batchSize = 1000;
        HashSet<DefaultIssue> changedIssuesToNotify = new HashSet<DefaultIssue>(batchSize);
        while (issues.hasNext()) {
            DefaultIssue issue = (DefaultIssue)issues.next();
            if (issue.type() != RuleType.SECURITY_HOTSPOT) {
                if (issue.isNew() && issue.resolution() == null) {
                    newIssuesStats.add(issue);
                } else if (issue.isChanged() && issue.mustSendNotifications()) {
                    changedIssuesToNotify.add(issue);
                }
            }
            if (changedIssuesToNotify.size() < batchSize) continue;
            this.sendIssuesChangesNotification(changedIssuesToNotify, assigneesByUuid, notificationStatistics);
            changedIssuesToNotify.clear();
        }
        if (!changedIssuesToNotify.isEmpty()) {
            this.sendIssuesChangesNotification(changedIssuesToNotify, assigneesByUuid, notificationStatistics);
        }
    }

    private void sendIssuesChangesNotification(Set<DefaultIssue> issues, Map<String, UserDto> assigneesByUuid, NotificationStatistics notificationStatistics) {
        IssuesChangesNotification notification = this.notificationFactory.newIssuesChangesNotification(issues, assigneesByUuid);
        notificationStatistics.issueChangesDeliveries += this.service.deliverEmails(Collections.singleton(notification));
        notificationStatistics.issueChanges++;
        notificationStatistics.issueChangesDeliveries += this.service.deliver((Notification)notification);
    }

    private void sendNewIssuesNotification(NewIssuesStatistics statistics, Component project, Map<String, UserDto> assigneesByUuid, long analysisDate, NotificationStatistics notificationStatistics) {
        NewIssuesStatistics.Stats globalStatistics = statistics.globalStatistics();
        NewIssuesNotification notification = this.notificationFactory.newNewIssuesNotification(assigneesByUuid).setProject(project.getKey(), project.getName(), this.getBranchName(), this.getPullRequest()).setProjectVersion(project.getProjectAttributes().getProjectVersion()).setAnalysisDate(new Date(analysisDate)).setStatistics(project.getName(), globalStatistics).setDebt(Duration.create((long)globalStatistics.effort().getOnLeak()));
        notificationStatistics.newIssuesDeliveries += this.service.deliverEmails(Collections.singleton(notification));
        notificationStatistics.newIssues++;
        notificationStatistics.newIssuesDeliveries += this.service.deliver((Notification)notification);
    }

    private void sendMyNewIssuesNotification(NewIssuesStatistics statistics, Component project, Map<String, UserDto> assigneesByUuid, long analysisDate, NotificationStatistics notificationStatistics) {
        Map<String, UserDto> userDtoByUuid = this.loadUserDtoByUuid(statistics);
        Set myNewIssuesNotifications = (Set)statistics.getAssigneesStatistics().entrySet().stream().filter(e -> ((NewIssuesStatistics.Stats)e.getValue()).hasIssuesOnLeak()).map(e -> {
            String assigneeUuid = (String)e.getKey();
            NewIssuesStatistics.Stats assigneeStatistics = (NewIssuesStatistics.Stats)e.getValue();
            MyNewIssuesNotification myNewIssuesNotification = this.notificationFactory.newMyNewIssuesNotification(assigneesByUuid).setAssignee((UserDto)userDtoByUuid.get(assigneeUuid));
            myNewIssuesNotification.setProject(project.getKey(), project.getName(), this.getBranchName(), this.getPullRequest()).setProjectVersion(project.getProjectAttributes().getProjectVersion()).setAnalysisDate(new Date(analysisDate)).setStatistics(project.getName(), assigneeStatistics).setDebt(Duration.create((long)assigneeStatistics.effort().getOnLeak()));
            return myNewIssuesNotification;
        }).collect(MoreCollectors.toSet((int)statistics.getAssigneesStatistics().size()));
        notificationStatistics.myNewIssuesDeliveries += this.service.deliverEmails((Collection)myNewIssuesNotifications);
        notificationStatistics.myNewIssues += myNewIssuesNotifications.size();
        myNewIssuesNotifications.forEach(e -> notificationStatistics.myNewIssuesDeliveries += this.service.deliver((Notification)e));
    }

    private Map<String, UserDto> loadUserDtoByUuid(NewIssuesStatistics statistics) {
        List entriesWithIssuesOnLeak = statistics.getAssigneesStatistics().entrySet().stream().filter(e -> ((NewIssuesStatistics.Stats)e.getValue()).hasIssuesOnLeak()).collect(Collectors.toList());
        List assigneeUuids = entriesWithIssuesOnLeak.stream().map(Map.Entry::getKey).collect(Collectors.toList());
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Map<String, UserDto> map = this.dbClient.userDao().selectByUuids(dbSession, assigneeUuids).stream().collect(Collectors.toMap(UserDto::getUuid, u -> u));
            return map;
        }
    }

    public String getDescription() {
        return "Send issue notifications";
    }

    @CheckForNull
    private String getBranchName() {
        Branch branch = this.analysisMetadataHolder.getBranch();
        return branch.isMain() || branch.getType() == BranchType.PULL_REQUEST ? null : branch.getName();
    }

    @CheckForNull
    private String getPullRequest() {
        Branch branch = this.analysisMetadataHolder.getBranch();
        return branch.getType() == BranchType.PULL_REQUEST ? this.analysisMetadataHolder.getPullRequestKey() : null;
    }

    private static class NotificationStatistics {
        private int issueChanges = 0;
        private int issueChangesDeliveries = 0;
        private int newIssues = 0;
        private int newIssuesDeliveries = 0;
        private int myNewIssues = 0;
        private int myNewIssuesDeliveries = 0;

        private NotificationStatistics() {
        }

        private void dumpTo(ComputationStep.Context context) {
            context.getStatistics().add("newIssuesNotifs", (Object)this.newIssues).add("newIssuesDeliveries", (Object)this.newIssuesDeliveries).add("myNewIssuesNotifs", (Object)this.myNewIssues).add("myNewIssuesDeliveries", (Object)this.myNewIssuesDeliveries).add("changesNotifs", (Object)this.issueChanges).add("changesDeliveries", (Object)this.issueChangesDeliveries);
        }
    }
}

