/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.PathAwareCrawler;
import org.sonar.ce.task.projectanalysis.component.PathAwareVisitor;
import org.sonar.ce.task.projectanalysis.component.PathAwareVisitorAdapter;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.projectanalysis.formula.Formula;
import org.sonar.ce.task.projectanalysis.formula.FormulaExecutorComponentVisitor;
import org.sonar.ce.task.projectanalysis.formula.SumFormula;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.ce.task.step.ComputationStep;

public class SizeMeasuresStep
implements ComputationStep {
    private static final CounterStackElementFactory COUNTER_STACK_ELEMENT_FACTORY = new CounterStackElementFactory();
    private static final List<Formula> AGGREGATED_SIZE_MEASURE_FORMULAS = Collections.unmodifiableList(Arrays.asList(SumFormula.createIntSumFormula("generated_lines"), SumFormula.createIntSumFormula("ncloc"), SumFormula.createIntSumFormula("generated_ncloc"), SumFormula.createIntSumFormula("functions"), SumFormula.createIntSumFormula("statements"), SumFormula.createIntSumFormula("classes")));
    private final TreeRootHolder treeRootHolder;
    private final MetricRepository metricRepository;
    private final MeasureRepository measureRepository;

    public SizeMeasuresStep(TreeRootHolder treeRootHolder, MetricRepository metricRepository, MeasureRepository measureRepository) {
        this.treeRootHolder = treeRootHolder;
        this.metricRepository = metricRepository;
        this.measureRepository = measureRepository;
    }

    public void execute(ComputationStep.Context context) {
        new PathAwareCrawler<Counter>(new FileAndDirectoryMeasureVisitor(this.metricRepository.getByKey("files"), this.metricRepository.getByKey("lines"))).visit(this.treeRootHolder.getRoot());
        new PathAwareCrawler<FormulaExecutorComponentVisitor.Counters>(FormulaExecutorComponentVisitor.newBuilder(this.metricRepository, this.measureRepository).buildFor(AGGREGATED_SIZE_MEASURE_FORMULAS)).visit(this.treeRootHolder.getRoot());
    }

    public String getDescription() {
        return "Compute size measures";
    }

    private static class CounterStackElementFactory
    extends PathAwareVisitorAdapter.SimpleStackElementFactory<Counter> {
        private CounterStackElementFactory() {
        }

        @Override
        public Counter createForAny(Component component) {
            return new Counter();
        }

        @Override
        public Counter createForFile(Component file) {
            return null;
        }

        @Override
        public Counter createForProjectView(Component projectView) {
            return null;
        }
    }

    private static class Counter {
        private int lines = 0;
        private int files = 0;

        private Counter() {
        }

        void aggregate(Counter counter) {
            this.files += counter.files;
            this.lines += counter.lines;
        }
    }

    private class FileAndDirectoryMeasureVisitor
    extends PathAwareVisitorAdapter<Counter> {
        private final Metric fileMetric;
        private final Metric linesMetric;

        public FileAndDirectoryMeasureVisitor(Metric fileMetric, Metric linesMetric) {
            super(CrawlerDepthLimit.LEAVES, ComponentVisitor.Order.POST_ORDER, COUNTER_STACK_ELEMENT_FACTORY);
            this.fileMetric = fileMetric;
            this.linesMetric = linesMetric;
        }

        @Override
        public void visitProject(Component project, PathAwareVisitor.Path<Counter> path) {
            this.createMeasures(project, path.current());
        }

        @Override
        public void visitDirectory(Component directory, PathAwareVisitor.Path<Counter> path) {
            int mainfileCount = path.current().files;
            if (mainfileCount > 0) {
                SizeMeasuresStep.this.measureRepository.add(directory, this.fileMetric, Measure.newMeasureBuilder().create(mainfileCount));
                SizeMeasuresStep.this.measureRepository.add(directory, this.linesMetric, Measure.newMeasureBuilder().create(path.current().lines));
                path.parent().files += mainfileCount;
                path.parent().lines += path.current().lines;
            }
        }

        private void createMeasures(Component directory, Counter counter) {
            if (counter.files > 0) {
                SizeMeasuresStep.this.measureRepository.add(directory, this.fileMetric, Measure.newMeasureBuilder().create(counter.files));
                SizeMeasuresStep.this.measureRepository.add(directory, this.linesMetric, Measure.newMeasureBuilder().create(counter.lines));
            }
        }

        @Override
        public void visitFile(Component file, PathAwareVisitor.Path<Counter> path) {
            if (file.getFileAttributes().isUnitTest()) {
                return;
            }
            int lines = file.getFileAttributes().getLines();
            SizeMeasuresStep.this.measureRepository.add(file, this.fileMetric, Measure.newMeasureBuilder().create(1));
            SizeMeasuresStep.this.measureRepository.add(file, this.linesMetric, Measure.newMeasureBuilder().create(lines));
            path.parent().lines += lines;
            path.parent().files += 1;
        }

        @Override
        public void visitView(Component view, PathAwareVisitor.Path<Counter> path) {
            this.createMeasures(view, path.current());
        }

        @Override
        public void visitSubView(Component subView, PathAwareVisitor.Path<Counter> path) {
            this.createMeasures(subView, path.current());
            path.parent().aggregate(path.current());
        }

        @Override
        public void visitProjectView(Component projectView, PathAwareVisitor.Path<Counter> path) {
            path.parent().files += this.getIntValue(projectView, this.fileMetric);
            path.parent().lines += this.getIntValue(projectView, this.linesMetric);
        }

        private int getIntValue(Component component, Metric metric) {
            Optional<Measure> fileMeasure = SizeMeasuresStep.this.measureRepository.getRawMeasure(component, metric);
            return fileMeasure.map(Measure::getIntValue).orElse(0);
        }
    }
}

