/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.dialect;

import com.google.common.collect.ImmutableList;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.Version;
import org.sonar.db.dialect.AbstractDialect;

public class Oracle
extends AbstractDialect {
    public static final String ID = "oracle";
    private static final List<String> INIT_STATEMENTS = ImmutableList.of((Object)"ALTER SESSION SET NLS_SORT='BINARY'");
    private static final Version MIN_SUPPORTED_VERSION = Version.create((int)11, (int)0, (int)0);

    public Oracle() {
        super(ID, "oracle.jdbc.OracleDriver", "1", "0", "SELECT 1 FROM DUAL");
    }

    @Override
    public boolean matchesJdbcUrl(String jdbcConnectionURL) {
        return StringUtils.startsWithIgnoreCase((String)jdbcConnectionURL, (String)"jdbc:oracle:");
    }

    @Override
    public boolean supportsMigration() {
        return true;
    }

    @Override
    public List<String> getConnectionInitStatements() {
        return INIT_STATEMENTS;
    }

    @Override
    public String getSqlFromDual() {
        return "from dual";
    }

    @Override
    public void init(DatabaseMetaData metaData) throws SQLException {
        this.checkDbVersion(metaData, MIN_SUPPORTED_VERSION);
        Oracle.checkDriverVersion(metaData);
    }

    private static void checkDriverVersion(DatabaseMetaData metaData) throws SQLException {
        String driverVersion = metaData.getDriverVersion();
        String[] parts = StringUtils.split((String)driverVersion, (String)".");
        int intVersion = Integer.parseInt(parts[0]) * 100 + Integer.parseInt(parts[1]);
        if (intVersion < 1200) {
            throw MessageException.of((String)String.format("Unsupported Oracle driver version: %s. Minimal supported version is 12.1.", driverVersion));
        }
    }
}

