/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.profiling;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Statement;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Profiler;
import org.sonar.db.profiling.InvocationUtils;
import org.sonar.db.profiling.ProfiledDataSource;
import org.sonar.db.profiling.SqlLogFormatter;

class ProfilingStatementHandler
implements InvocationHandler {
    private final Statement statement;

    ProfilingStatementHandler(Statement statement) {
        this.statement = statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().startsWith("execute")) {
            Profiler profiler = Profiler.create((Logger)ProfiledDataSource.SQL_LOGGER).start();
            Object result = null;
            try {
                result = InvocationUtils.invokeQuietly(this.statement, method, args);
            }
            finally {
                String sql = (String)args[0];
                profiler.addContext("sql", (Object)SqlLogFormatter.reformatSql(sql));
                profiler.stopTrace("");
            }
            return result;
        }
        return InvocationUtils.invokeQuietly(this.statement, method, args);
    }
}

