/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.ce;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.sonar.api.utils.System2;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.ce.CeTaskInputMapper;

public class CeTaskInputDao
implements Dao {
    private final System2 system;

    public CeTaskInputDao(System2 system) {
        this.system = system;
    }

    public void insert(DbSession dbSession, String taskUuid, InputStream data) {
        long now = this.system.now();
        Connection connection = dbSession.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement("INSERT INTO ce_task_input (task_uuid, created_at, updated_at, input_data) VALUES (?, ?, ?, ?)");){
            stmt.setString(1, taskUuid);
            stmt.setLong(2, now);
            stmt.setLong(3, now);
            stmt.setBinaryStream(4, data);
            stmt.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            throw new IllegalStateException("Fail to insert data of CE task " + taskUuid, e);
        }
    }

    public Optional<DataStream> selectData(DbSession dbSession, String taskUuid) {
        Optional<DataStream> optional;
        block8: {
            DataStream result;
            ResultSet rs;
            PreparedStatement stmt;
            block6: {
                Optional<DataStream> optional2;
                block7: {
                    stmt = null;
                    rs = null;
                    result = null;
                    stmt = dbSession.getConnection().prepareStatement("SELECT input_data FROM ce_task_input WHERE task_uuid=? AND input_data IS NOT NULL");
                    stmt.setString(1, taskUuid);
                    rs = stmt.executeQuery();
                    if (!rs.next()) break block6;
                    result = new DataStream(stmt, rs, rs.getBinaryStream(1));
                    optional2 = Optional.of(result);
                    if (result != null) break block7;
                    DatabaseUtils.closeQuietly((ResultSet)rs);
                    DatabaseUtils.closeQuietly((Statement)stmt);
                }
                return optional2;
            }
            try {
                optional = Optional.empty();
                if (result != null) break block8;
            }
            catch (SQLException e) {
                try {
                    throw new IllegalStateException("Fail to select data of CE task " + taskUuid, e);
                }
                catch (Throwable throwable) {
                    if (result == null) {
                        DatabaseUtils.closeQuietly(rs);
                        DatabaseUtils.closeQuietly((Statement)stmt);
                    }
                    throw throwable;
                }
            }
            DatabaseUtils.closeQuietly((ResultSet)rs);
            DatabaseUtils.closeQuietly((Statement)stmt);
        }
        return optional;
    }

    public List<String> selectUuidsNotInQueue(DbSession dbSession) {
        return ((CeTaskInputMapper)dbSession.getMapper(CeTaskInputMapper.class)).selectUuidsNotInQueue();
    }

    public void deleteByUuids(DbSession dbSession, Collection<String> uuids) {
        CeTaskInputMapper mapper = (CeTaskInputMapper)dbSession.getMapper(CeTaskInputMapper.class);
        DatabaseUtils.executeLargeUpdates(uuids, mapper::deleteByUuids);
    }

    public static class DataStream
    implements AutoCloseable {
        private final PreparedStatement stmt;
        private final ResultSet rs;
        private final InputStream stream;

        private DataStream(PreparedStatement stmt, ResultSet rs, InputStream stream) {
            this.stmt = stmt;
            this.rs = rs;
            this.stream = stream;
        }

        public InputStream getInputStream() {
            return this.stream;
        }

        @Override
        public void close() {
            IOUtils.closeQuietly((InputStream)this.stream);
            DatabaseUtils.closeQuietly((ResultSet)this.rs);
            DatabaseUtils.closeQuietly((Statement)this.stmt);
        }
    }
}

