/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.ce;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.db.ce.CeQueueDto;

public final class UpdateIf {
    private UpdateIf() {
    }

    @Immutable
    public static class OldProperties {
        private final CeQueueDto.Status status;

        public OldProperties(CeQueueDto.Status status) {
            this.status = Objects.requireNonNull(status, "status can't be null");
        }

        public CeQueueDto.Status getStatus() {
            return this.status;
        }
    }

    @Immutable
    public static class NewProperties {
        private final CeQueueDto.Status status;
        private final String workerUuid;
        private final Long startedAt;
        private final long updatedAt;

        public NewProperties(CeQueueDto.Status status, @Nullable String workerUuid, long startedAt, long updatedAt) {
            Preconditions.checkArgument((workerUuid == null || workerUuid.length() <= 40 ? 1 : 0) != 0, (String)"worker uuid is too long: %s", (Object[])new Object[]{workerUuid});
            this.status = Objects.requireNonNull(status, "status can't be null");
            this.workerUuid = workerUuid;
            this.startedAt = startedAt;
            this.updatedAt = updatedAt;
        }

        public CeQueueDto.Status getStatus() {
            return this.status;
        }

        @CheckForNull
        public String getWorkerUuid() {
            return this.workerUuid;
        }

        public Long getStartedAt() {
            return this.startedAt;
        }

        public long getUpdatedAt() {
            return this.updatedAt;
        }
    }
}

