/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.issue;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.api.utils.System2;
import org.sonar.core.issue.DefaultIssueComment;
import org.sonar.core.issue.FieldDiffs;

public final class IssueChangeDto
implements Serializable {
    public static final String TYPE_FIELD_CHANGE = "diff";
    public static final String TYPE_COMMENT = "comment";
    private Long id;
    private String kee;
    private String issueKey;
    private String userUuid;
    private String changeType;
    private String changeData;
    private Long createdAt;
    private Long updatedAt;
    @Nullable
    private Long issueChangeCreationDate;

    public static IssueChangeDto of(DefaultIssueComment comment) {
        IssueChangeDto dto = IssueChangeDto.newDto(comment.issueKey());
        dto.setKey(comment.key());
        dto.setChangeType(TYPE_COMMENT);
        dto.setChangeData(comment.markdownText());
        dto.setUserUuid(comment.userUuid());
        Date createdAt = Objects.requireNonNull(comment.createdAt(), "Comment created at must not be null");
        dto.setIssueChangeCreationDate(createdAt.getTime());
        return dto;
    }

    public static IssueChangeDto of(String issueKey, FieldDiffs diffs) {
        IssueChangeDto dto = IssueChangeDto.newDto(issueKey);
        dto.setChangeType(TYPE_FIELD_CHANGE);
        dto.setChangeData(diffs.toEncodedString());
        dto.setUserUuid(diffs.userUuid());
        Date createdAt = Objects.requireNonNull(diffs.creationDate(), "Diffs created at must not be null");
        dto.setIssueChangeCreationDate(createdAt.getTime());
        return dto;
    }

    private static IssueChangeDto newDto(String issueKey) {
        IssueChangeDto dto = new IssueChangeDto();
        dto.setIssueKey(issueKey);
        dto.setCreatedAt(System2.INSTANCE.now());
        dto.setUpdatedAt(System2.INSTANCE.now());
        return dto;
    }

    public Long getId() {
        return this.id;
    }

    public IssueChangeDto setId(Long id) {
        this.id = id;
        return this;
    }

    @CheckForNull
    public String getKey() {
        return this.kee;
    }

    public IssueChangeDto setKey(@Nullable String key) {
        this.kee = key;
        return this;
    }

    public String getIssueKey() {
        return this.issueKey;
    }

    public IssueChangeDto setIssueKey(String s) {
        this.issueKey = s;
        return this;
    }

    @CheckForNull
    public String getUserUuid() {
        return this.userUuid;
    }

    public IssueChangeDto setUserUuid(@Nullable String userUuid) {
        this.userUuid = userUuid;
        return this;
    }

    public String getChangeType() {
        return this.changeType;
    }

    public IssueChangeDto setChangeType(String changeType) {
        this.changeType = changeType;
        return this;
    }

    public String getChangeData() {
        return this.changeData;
    }

    public IssueChangeDto setChangeData(String changeData) {
        this.changeData = changeData;
        return this;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public IssueChangeDto setCreatedAt(Long createdAt) {
        this.createdAt = (Long)Preconditions.checkNotNull((Object)createdAt);
        return this;
    }

    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    public IssueChangeDto setUpdatedAt(@Nullable Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    public Long getIssueChangeCreationDate() {
        return this.issueChangeCreationDate == null ? this.createdAt : this.issueChangeCreationDate;
    }

    public IssueChangeDto setIssueChangeCreationDate(long issueChangeCreationDate) {
        this.issueChangeCreationDate = issueChangeCreationDate;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public DefaultIssueComment toComment() {
        return new DefaultIssueComment().setMarkdownText(this.changeData).setKey(this.kee).setCreatedAt(new Date(this.getIssueChangeCreationDate())).setUpdatedAt(this.updatedAt == null ? null : new Date(this.updatedAt)).setUserUuid(this.userUuid).setIssueKey(this.issueKey).setNew(false);
    }

    public FieldDiffs toFieldDiffs() {
        return FieldDiffs.parse((String)this.changeData).setUserUuid(this.userUuid).setCreationDate(new Date(this.getIssueChangeCreationDate())).setIssueKey(this.issueKey);
    }
}

