/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.measure;

import com.google.common.base.MoreObjects;
import java.nio.charset.StandardCharsets;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class MeasureDto {
    private static final int MAX_TEXT_VALUE_LENGTH = 4000;
    private Double value;
    private String textValue;
    private byte[] dataValue;
    private Double variation;
    private String alertStatus;
    private String alertText;
    private String componentUuid;
    private String analysisUuid;
    private int metricId;

    @CheckForNull
    public Double getValue() {
        return this.value;
    }

    public MeasureDto setValue(@Nullable Double value) {
        this.value = value;
        return this;
    }

    public String getComponentUuid() {
        return this.componentUuid;
    }

    public MeasureDto setComponentUuid(String s) {
        this.componentUuid = s;
        return this;
    }

    @CheckForNull
    public String getData() {
        if (this.dataValue != null) {
            return new String(this.dataValue, StandardCharsets.UTF_8);
        }
        return this.textValue;
    }

    public MeasureDto setData(@Nullable String data) {
        if (data == null) {
            this.textValue = null;
            this.dataValue = null;
        } else if (data.length() > 4000) {
            this.textValue = null;
            this.dataValue = data.getBytes(StandardCharsets.UTF_8);
        } else {
            this.textValue = data;
            this.dataValue = null;
        }
        return this;
    }

    @CheckForNull
    public Double getVariation() {
        return this.variation;
    }

    public MeasureDto setVariation(@Nullable Double d) {
        this.variation = d;
        return this;
    }

    @CheckForNull
    public String getAlertStatus() {
        return this.alertStatus;
    }

    public MeasureDto setAlertStatus(@Nullable String alertStatus) {
        this.alertStatus = alertStatus;
        return this;
    }

    @CheckForNull
    public String getAlertText() {
        return this.alertText;
    }

    public MeasureDto setAlertText(@Nullable String alertText) {
        this.alertText = alertText;
        return this;
    }

    public int getMetricId() {
        return this.metricId;
    }

    public MeasureDto setMetricId(int metricId) {
        this.metricId = metricId;
        return this;
    }

    public String getAnalysisUuid() {
        return this.analysisUuid;
    }

    public MeasureDto setAnalysisUuid(String s) {
        this.analysisUuid = s;
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).add("textValue", (Object)this.textValue).add("dataValue", (Object)this.dataValue).add("variation", (Object)this.variation).add("alertStatus", (Object)this.alertStatus).add("alertText", (Object)this.alertText).add("componentUuid", (Object)this.componentUuid).add("analysisUuid", (Object)this.analysisUuid).add("metricId", this.metricId).toString();
    }
}

