/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.measure;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class MeasureQuery {
    @CheckForNull
    private final String analysisUuid;
    @CheckForNull
    private final Collection<String> projectUuids;
    @CheckForNull
    private final Collection<String> componentUuids;
    @CheckForNull
    private final Collection<Integer> metricIds;
    @CheckForNull
    private final Collection<String> metricKeys;

    private MeasureQuery(Builder builder) {
        this(builder.analysisUuid, builder.projectUuids, builder.componentUuids, builder.metricIds, builder.metricKeys);
    }

    private MeasureQuery(@Nullable String analysisUuid, @Nullable Collection<String> projectUuids, @Nullable Collection<String> componentUuids, @Nullable Collection<Integer> metricIds, @Nullable Collection<String> metricKeys) {
        Preconditions.checkArgument((metricIds == null || metricKeys == null ? 1 : 0) != 0, (Object)"Metric IDs and keys must not be set both");
        Preconditions.checkArgument((projectUuids != null || componentUuids != null ? 1 : 0) != 0, (Object)"At least one filter on component UUID is expected");
        Preconditions.checkArgument((componentUuids == null || componentUuids.size() == 1 || projectUuids != null && projectUuids.size() == 1 ? 1 : 0) != 0, (Object)"Component UUIDs can only be used when a single project UUID is set");
        this.analysisUuid = analysisUuid;
        this.projectUuids = projectUuids;
        this.componentUuids = componentUuids;
        this.metricIds = metricIds;
        this.metricKeys = metricKeys;
    }

    public String getAnalysisUuid() {
        return this.analysisUuid;
    }

    @CheckForNull
    public Collection<String> getProjectUuids() {
        return this.projectUuids;
    }

    @CheckForNull
    public String getProjectUuid() {
        return this.isOnComponents() ? this.projectUuids.iterator().next() : null;
    }

    @CheckForNull
    public Collection<String> getComponentUuids() {
        return this.componentUuids;
    }

    @CheckForNull
    public String getComponentUuid() {
        return this.isOnSingleComponent() ? this.componentUuids.iterator().next() : null;
    }

    @CheckForNull
    public Collection<Integer> getMetricIds() {
        return this.metricIds;
    }

    @CheckForNull
    public Collection<String> getMetricKeys() {
        return this.metricKeys;
    }

    public boolean returnsEmpty() {
        return this.projectUuids != null && this.projectUuids.isEmpty() || this.componentUuids != null && this.componentUuids.isEmpty() || this.metricIds != null && this.metricIds.isEmpty() || this.metricKeys != null && this.metricKeys.isEmpty();
    }

    public boolean isOnProjects() {
        return this.projectUuids != null && this.componentUuids == null;
    }

    public boolean isOnComponents() {
        return this.projectUuids != null && this.projectUuids.size() == 1 && this.componentUuids != null;
    }

    public boolean isOnSingleComponent() {
        return this.projectUuids == null && this.componentUuids != null && this.componentUuids.size() == 1;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeasureQuery that = (MeasureQuery)o;
        return Objects.equals(this.analysisUuid, that.analysisUuid) && Objects.equals(this.projectUuids, that.projectUuids) && Objects.equals(this.componentUuids, that.componentUuids) && Objects.equals(this.metricIds, that.metricIds) && Objects.equals(this.metricKeys, that.metricKeys);
    }

    public int hashCode() {
        return Objects.hash(this.analysisUuid, this.componentUuids, this.metricIds, this.metricKeys);
    }

    public static Builder builder() {
        return new Builder();
    }

    static MeasureQuery copyWithSubsetOfProjectUuids(MeasureQuery query, Collection<String> projectUuids) {
        return new MeasureQuery(query.analysisUuid, projectUuids, query.componentUuids, query.metricIds, query.metricKeys);
    }

    static MeasureQuery copyWithSubsetOfComponentUuids(MeasureQuery query, Collection<String> componentUuids) {
        return new MeasureQuery(query.analysisUuid, query.projectUuids, componentUuids, query.metricIds, query.metricKeys);
    }

    public static final class Builder {
        private String analysisUuid;
        private Collection<String> projectUuids;
        private Collection<String> componentUuids;
        private Collection<Integer> metricIds;
        private Collection<String> metricKeys;

        private Builder() {
        }

        public Builder setAnalysisUuid(String analysisUuid) {
            this.analysisUuid = analysisUuid;
            return this;
        }

        public Builder setProjectUuids(@Nullable Collection<String> projectUuids) {
            this.projectUuids = projectUuids;
            return this;
        }

        public Builder setComponentUuids(String projectUuid, Collection<String> componentUuids) {
            this.setProjectUuids(Collections.singleton(Objects.requireNonNull(projectUuid)));
            this.componentUuids = componentUuids;
            return this;
        }

        public Builder setComponentUuid(String componentUuid) {
            this.componentUuids = Collections.singleton(componentUuid);
            return this;
        }

        public Builder setMetricIds(@Nullable Collection<Integer> metricIds) {
            this.metricIds = metricIds;
            return this;
        }

        public Builder setMetricId(int metricId) {
            this.metricIds = Collections.singleton(metricId);
            return this;
        }

        public Builder setMetricKeys(@Nullable Collection<String> s) {
            this.metricKeys = s;
            return this;
        }

        public Builder setMetricKey(String s) {
            this.metricKeys = Collections.singleton(s);
            return this;
        }

        public MeasureQuery build() {
            return new MeasureQuery(this);
        }
    }
}

