/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.qualitygate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.db.DaoUtils;
import org.sonar.db.WildcardPosition;
import org.sonar.db.qualitygate.QGateWithOrgDto;

public class ProjectQgateAssociationQuery {
    public static final int DEFAULT_PAGE_INDEX = 1;
    public static final int DEFAULT_PAGE_SIZE = 100;
    public static final String ANY = "all";
    public static final String IN = "selected";
    public static final String OUT = "deselected";
    public static final Set<String> AVAILABLE_MEMBERSHIP = ImmutableSet.of((Object)"all", (Object)"selected", (Object)"deselected");
    private final String gateId;
    private final String organizationUuid;
    private final String membership;
    private final String projectSearch;
    private final String projectSearchUpperLikeSql;
    private final int pageSize;
    private final int pageIndex;

    private ProjectQgateAssociationQuery(Builder builder) {
        this.gateId = Long.toString(builder.qualityGate.getId());
        this.organizationUuid = builder.qualityGate.getOrganizationUuid();
        this.membership = builder.membership;
        this.projectSearch = builder.projectSearch;
        this.projectSearchUpperLikeSql = this.projectSearch == null ? null : DaoUtils.buildLikeValue(this.projectSearch.toUpperCase(Locale.ENGLISH), WildcardPosition.BEFORE_AND_AFTER);
        this.pageSize = builder.pageSize;
        this.pageIndex = builder.pageIndex;
    }

    public String gateId() {
        return this.gateId;
    }

    public String organizationUuid() {
        return this.organizationUuid;
    }

    @CheckForNull
    public String membership() {
        return this.membership;
    }

    @CheckForNull
    public String projectSearch() {
        return this.projectSearch;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public int pageIndex() {
        return this.pageIndex;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private QGateWithOrgDto qualityGate;
        private String membership;
        private String projectSearch;
        private Integer pageIndex = 1;
        private Integer pageSize = 100;

        private Builder() {
        }

        public Builder qualityGate(QGateWithOrgDto qualityGate) {
            this.qualityGate = qualityGate;
            return this;
        }

        public Builder membership(@Nullable String membership) {
            this.membership = membership;
            return this;
        }

        public Builder projectSearch(@Nullable String s) {
            this.projectSearch = StringUtils.defaultIfBlank((String)s, null);
            return this;
        }

        public Builder pageSize(@Nullable Integer i) {
            this.pageSize = i;
            return this;
        }

        public Builder pageIndex(@Nullable Integer i) {
            this.pageIndex = i;
            return this;
        }

        private void initMembership() {
            if (this.membership == null) {
                this.membership = ProjectQgateAssociationQuery.ANY;
            } else {
                Preconditions.checkArgument((boolean)AVAILABLE_MEMBERSHIP.contains(this.membership), (Object)("Membership is not valid (got " + this.membership + "). Available values are " + AVAILABLE_MEMBERSHIP));
            }
        }

        private void initPageSize() {
            if (this.pageSize == null) {
                this.pageSize = 100;
            }
        }

        private void initPageIndex() {
            if (this.pageIndex == null) {
                this.pageIndex = 1;
            }
            Preconditions.checkArgument((this.pageIndex > 0 ? 1 : 0) != 0, (Object)("Page index must be greater than 0 (got " + this.pageIndex + ")"));
        }

        public ProjectQgateAssociationQuery build() {
            this.initMembership();
            this.initPageIndex();
            this.initPageSize();
            return new ProjectQgateAssociationQuery(this);
        }
    }
}

