/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.qualityprofile;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.rule.RuleStatus;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.QProfileDto;

public class ActiveRuleCountQuery {
    private final OrganizationDto organization;
    private final List<String> profileUuids;
    private final RuleStatus ruleStatus;
    private final String inheritance;

    public ActiveRuleCountQuery(Builder builder) {
        this.profileUuids = (List)builder.profiles.stream().map(QProfileDto::getKee).collect(MoreCollectors.toList());
        this.ruleStatus = builder.ruleStatus;
        this.inheritance = builder.inheritance;
        this.organization = builder.organization;
    }

    public OrganizationDto getOrganization() {
        return this.organization;
    }

    public List<String> getProfileUuids() {
        return this.profileUuids;
    }

    @CheckForNull
    public RuleStatus getRuleStatus() {
        return this.ruleStatus;
    }

    @CheckForNull
    public String getInheritance() {
        return this.inheritance;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private OrganizationDto organization;
        private List<QProfileDto> profiles;
        private RuleStatus ruleStatus;
        private String inheritance;

        public Builder setOrganization(OrganizationDto organization) {
            this.organization = organization;
            return this;
        }

        public Builder setProfiles(List<QProfileDto> profiles) {
            this.profiles = profiles;
            return this;
        }

        public Builder setRuleStatus(@Nullable RuleStatus ruleStatus) {
            this.ruleStatus = ruleStatus;
            return this;
        }

        public Builder setInheritance(@Nullable String inheritance) {
            this.inheritance = inheritance;
            return this;
        }

        public ActiveRuleCountQuery build() {
            Preconditions.checkState((this.organization != null ? 1 : 0) != 0, (Object)"Organization cannot be null");
            Preconditions.checkState((this.profiles != null ? 1 : 0) != 0, (Object)"Profiles cannot be null");
            return new ActiveRuleCountQuery(this);
        }
    }
}

