/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.notification;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.api.notifications.Notification;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.issue.notification.FPOrWontFixNotification;
import org.sonar.server.issue.notification.IssuesChangesNotification;
import org.sonar.server.issue.notification.IssuesChangesNotificationBuilder;
import org.sonar.server.issue.notification.IssuesChangesNotificationSerializer;
import org.sonar.server.issue.notification.NotificationWithProjectKeys;
import org.sonar.server.notification.EmailNotificationHandler;
import org.sonar.server.notification.NotificationDispatcherMetadata;
import org.sonar.server.notification.NotificationManager;
import org.sonar.server.notification.email.EmailNotificationChannel;

public class FPOrWontFixNotificationHandler
extends EmailNotificationHandler<IssuesChangesNotification> {
    public static final String KEY = "NewFalsePositiveIssue";
    private static final NotificationDispatcherMetadata METADATA = NotificationDispatcherMetadata.create("NewFalsePositiveIssue").setProperty("globalNotification", String.valueOf(false)).setProperty("perProjectNotification", String.valueOf(true));
    private static final Set<String> FP_OR_WONTFIX_RESOLUTIONS = ImmutableSet.of((Object)"FALSE-POSITIVE", (Object)"WONTFIX");
    private final NotificationManager notificationManager;
    private final IssuesChangesNotificationSerializer serializer;

    public FPOrWontFixNotificationHandler(NotificationManager notificationManager, EmailNotificationChannel emailNotificationChannel, IssuesChangesNotificationSerializer serializer) {
        super(emailNotificationChannel);
        this.notificationManager = notificationManager;
        this.serializer = serializer;
    }

    @Override
    public Optional<NotificationDispatcherMetadata> getMetadata() {
        return Optional.of(METADATA);
    }

    public static NotificationDispatcherMetadata newMetadata() {
        return METADATA;
    }

    @Override
    public Class<IssuesChangesNotification> getNotificationClass() {
        return IssuesChangesNotification.class;
    }

    @Override
    public Set<EmailNotificationChannel.EmailDeliveryRequest> toEmailDeliveryRequests(Collection<IssuesChangesNotification> notifications) {
        Set changeNotificationsWithFpOrWontFix = notifications.stream().map(this.serializer::from).filter(t -> t.getIssues().stream().filter(issue -> issue.getNewResolution().isPresent()).anyMatch(issue -> FP_OR_WONTFIX_RESOLUTIONS.contains(issue.getNewResolution().get()))).map(NotificationWithProjectKeys::new).collect(Collectors.toSet());
        if (changeNotificationsWithFpOrWontFix.isEmpty()) {
            return Collections.emptySet();
        }
        Set projectKeys = changeNotificationsWithFpOrWontFix.stream().flatMap(t -> t.getProjectKeys().stream()).collect(Collectors.toSet());
        if (projectKeys.size() == 1) {
            Set<NotificationManager.EmailRecipient> recipients = this.notificationManager.findSubscribedEmailRecipients(KEY, (String)projectKeys.iterator().next(), NotificationManager.SubscriberPermissionsOnProject.ALL_MUST_HAVE_ROLE_USER);
            return (Set)changeNotificationsWithFpOrWontFix.stream().flatMap(notification -> FPOrWontFixNotificationHandler.toRequests(notification, projectKeys, recipients)).collect(MoreCollectors.toSet((int)changeNotificationsWithFpOrWontFix.size()));
        }
        Set recipientsByProjectKey = projectKeys.stream().flatMap(projectKey -> this.notificationManager.findSubscribedEmailRecipients(KEY, (String)projectKey, NotificationManager.SubscriberPermissionsOnProject.ALL_MUST_HAVE_ROLE_USER).stream().map(emailRecipient -> new EmailRecipientAndProject((NotificationManager.EmailRecipient)emailRecipient, (String)projectKey))).collect(Collectors.toSet());
        SetMultimap projectKeysByRecipient = (SetMultimap)recipientsByProjectKey.stream().collect(MoreCollectors.unorderedIndex(t -> ((EmailRecipientAndProject)t).recipient, t -> ((EmailRecipientAndProject)t).projectKey));
        Multimap recipientsBySubscribedProjects = (Multimap)projectKeysByRecipient.asMap().entrySet().stream().collect(MoreCollectors.unorderedIndex(t -> (Set)t.getValue(), Map.Entry::getKey));
        return (Set)changeNotificationsWithFpOrWontFix.stream().flatMap(notification -> {
            SetMultimap recipientsByProjectKeys = (SetMultimap)recipientsBySubscribedProjects.asMap().entrySet().stream().collect(MoreCollectors.unorderedFlattenIndex(t -> Sets.intersection((Set)((Set)t.getKey()), notification.getProjectKeys()).immutableCopy(), t -> ((Collection)t.getValue()).stream()));
            return recipientsByProjectKeys.asMap().entrySet().stream().flatMap(entry -> FPOrWontFixNotificationHandler.toRequests(notification, (Set)entry.getKey(), (Collection)entry.getValue()));
        }).collect(MoreCollectors.toSet((int)changeNotificationsWithFpOrWontFix.size()));
    }

    private static Stream<EmailNotificationChannel.EmailDeliveryRequest> toRequests(NotificationWithProjectKeys notification, Set<String> projectKeys, Collection<NotificationManager.EmailRecipient> recipients) {
        return recipients.stream().filter(recipient -> !notification.getChange().isAuthorLogin(recipient.getLogin())).flatMap(recipient -> {
            SetMultimap issuesByNewResolution = (SetMultimap)notification.getIssues().stream().filter(issue -> issue.getNewResolution().filter(FP_OR_WONTFIX_RESOLUTIONS::contains).isPresent()).filter(issue -> projectKeys.contains(issue.getProject().getKey())).collect(MoreCollectors.unorderedIndex(t -> t.getNewResolution().get(), issue -> issue));
            return Stream.of(Optional.ofNullable(issuesByNewResolution.get((Object)"FALSE-POSITIVE")).filter(t -> !t.isEmpty()).map(fpIssues -> new FPOrWontFixNotification(notification.getChange(), (Collection<IssuesChangesNotificationBuilder.ChangedIssue>)fpIssues, FPOrWontFixNotification.FpOrWontFix.FP)).orElse(null), Optional.ofNullable(issuesByNewResolution.get((Object)"WONTFIX")).filter(t -> !t.isEmpty()).map(wontFixIssues -> new FPOrWontFixNotification(notification.getChange(), (Collection<IssuesChangesNotificationBuilder.ChangedIssue>)wontFixIssues, FPOrWontFixNotification.FpOrWontFix.WONT_FIX)).orElse(null)).filter(Objects::nonNull).map(fpOrWontFixNotification -> new EmailNotificationChannel.EmailDeliveryRequest(recipient.getEmail(), (Notification)fpOrWontFixNotification));
        });
    }

    private static final class EmailRecipientAndProject {
        private final NotificationManager.EmailRecipient recipient;
        private final String projectKey;

        private EmailRecipientAndProject(NotificationManager.EmailRecipient recipient, String projectKey) {
            this.recipient = recipient;
            this.projectKey = projectKey;
        }
    }
}

