/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.workflow;

import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import org.sonar.api.issue.Issue;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.FieldDiffs;
import org.sonar.server.issue.workflow.Condition;

class PreviousStatusWas
implements Condition {
    private final String expectedPreviousStatus;

    PreviousStatusWas(String expectedPreviousStatus) {
        this.expectedPreviousStatus = expectedPreviousStatus;
    }

    @Override
    public boolean matches(Issue issue) {
        DefaultIssue defaultIssue = (DefaultIssue)issue;
        Optional<String> lastPreviousStatus = defaultIssue.changes().stream().filter(change -> change != defaultIssue.currentChange()).filter(change -> change.creationDate() != null).sorted(Comparator.comparing(FieldDiffs::creationDate).reversed()).map(change -> change.get("status")).filter(Objects::nonNull).findFirst().map(t -> (String)((Object)t.oldValue()));
        return lastPreviousStatus.filter(this.expectedPreviousStatus::equals).isPresent();
    }
}

