/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.index;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.server.es.BaseDoc;
import org.sonar.server.qualityprofile.ActiveRuleInheritance;
import org.sonar.server.rule.index.RuleIndexDefinition;

public class ActiveRuleDoc
extends BaseDoc {
    public static final String DOC_ID_PREFIX = "ar_";

    public ActiveRuleDoc(long id) {
        super(RuleIndexDefinition.TYPE_ACTIVE_RULE, Maps.newHashMapWithExpectedSize((int)10));
        this.setField("activeRule_id", String.valueOf(id));
    }

    public ActiveRuleDoc(Map<String, Object> source) {
        super(RuleIndexDefinition.TYPE_ACTIVE_RULE, source);
    }

    public static String docIdOf(long activeRuleId) {
        return ActiveRuleDoc.docIdOf(String.valueOf(activeRuleId));
    }

    public static String docIdOf(String activeRuleId) {
        return DOC_ID_PREFIX + activeRuleId;
    }

    public static long activeRuleIdOf(String docId) {
        if (docId.startsWith(DOC_ID_PREFIX)) {
            return Long.valueOf(docId.substring(DOC_ID_PREFIX.length()));
        }
        return Long.valueOf(docId);
    }

    @Override
    public String getId() {
        return ActiveRuleDoc.docIdOf((String)this.getField("activeRule_id"));
    }

    ActiveRuleDoc setRuleId(int ruleId) {
        String parent = String.valueOf(ruleId);
        this.setParent(parent);
        this.setField("ruleId", parent);
        return this;
    }

    String getSeverity() {
        return (String)this.getNullableField("activeRule_severity");
    }

    ActiveRuleDoc setSeverity(@Nullable String s) {
        this.setField("activeRule_severity", s);
        return this;
    }

    String getRuleProfileUuid() {
        return (String)this.getField("activeRule_ruleProfile");
    }

    ActiveRuleDoc setRuleProfileUuid(String s) {
        this.setField("activeRule_ruleProfile", s);
        return this;
    }

    ActiveRuleInheritance getInheritance() {
        String inheritance = (String)this.getNullableField("activeRule_inheritance");
        if (inheritance == null || inheritance.isEmpty() || StringUtils.containsIgnoreCase((String)inheritance, (String)"none")) {
            return ActiveRuleInheritance.NONE;
        }
        if (StringUtils.containsIgnoreCase((String)inheritance, (String)"herit")) {
            return ActiveRuleInheritance.INHERITED;
        }
        if (StringUtils.containsIgnoreCase((String)inheritance, (String)"over")) {
            return ActiveRuleInheritance.OVERRIDES;
        }
        throw new IllegalStateException("Value \"" + inheritance + "\" is not valid for rule's inheritance");
    }

    public ActiveRuleDoc setInheritance(@Nullable String s) {
        this.setField("activeRule_inheritance", s);
        return this;
    }
}

