/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.es.EsQueueDto;
import org.sonar.db.es.RuleExtensionId;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.server.es.BulkIndexer;
import org.sonar.server.es.EsClient;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.IndexingListener;
import org.sonar.server.es.IndexingResult;
import org.sonar.server.es.OneToOneResilientIndexingListener;
import org.sonar.server.es.ResilientIndexer;
import org.sonar.server.rule.index.RuleDoc;
import org.sonar.server.rule.index.RuleExtensionDoc;
import org.sonar.server.rule.index.RuleExtensionScope;
import org.sonar.server.rule.index.RuleIndexDefinition;

public class RuleIndexer
implements ResilientIndexer {
    private final EsClient esClient;
    private final DbClient dbClient;

    public RuleIndexer(EsClient esClient, DbClient dbClient) {
        this.esClient = esClient;
        this.dbClient = dbClient;
    }

    @Override
    public Set<IndexType> getIndexTypes() {
        return ImmutableSet.of((Object)RuleIndexDefinition.TYPE_RULE, (Object)RuleIndexDefinition.TYPE_RULE_EXTENSION);
    }

    @Override
    public void indexOnStartup(Set<IndexType> uninitializedIndexTypes) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            BulkIndexer bulk = this.createBulkIndexer(BulkIndexer.Size.LARGE, IndexingListener.FAIL_ON_ERROR);
            bulk.start();
            if (uninitializedIndexTypes.contains(RuleIndexDefinition.TYPE_RULE)) {
                this.dbClient.ruleDao().scrollIndexingRules(dbSession, dto -> {
                    bulk.add(RuleDoc.of(dto).toIndexRequest());
                    bulk.add(RuleExtensionDoc.of(dto).toIndexRequest());
                });
            }
            if (uninitializedIndexTypes.contains(RuleIndexDefinition.TYPE_RULE_EXTENSION)) {
                this.dbClient.ruleDao().scrollIndexingRuleExtensions(dbSession, dto -> bulk.add(RuleExtensionDoc.of(dto).toIndexRequest()));
            }
            bulk.stop();
        }
    }

    public void commitAndIndex(DbSession dbSession, int ruleId) {
        this.commitAndIndex(dbSession, Collections.singletonList(ruleId));
    }

    public void commitAndIndex(DbSession dbSession, Collection<Integer> ruleIds) {
        List items = (List)ruleIds.stream().map(RuleIndexer::createQueueDtoForRule).collect(MoreCollectors.toArrayList());
        this.dbClient.esQueueDao().insert(dbSession, (Collection)items);
        dbSession.commit();
        this.postCommit(dbSession, items);
    }

    public void commitAndIndex(DbSession dbSession, int ruleId, OrganizationDto organization) {
        List<EsQueueDto> items = Arrays.asList(RuleIndexer.createQueueDtoForRule(ruleId), RuleIndexer.createQueueDtoForRuleExtension(ruleId, organization));
        this.dbClient.esQueueDao().insert(dbSession, items);
        dbSession.commit();
        this.postCommit(dbSession, items);
    }

    private void postCommit(DbSession dbSession, List<EsQueueDto> items) {
        this.index(dbSession, items);
    }

    @Override
    public IndexingResult index(DbSession dbSession, Collection<EsQueueDto> items) {
        IndexingResult result = new IndexingResult();
        if (!items.isEmpty()) {
            ListMultimap<String, EsQueueDto> itemsByType = RuleIndexer.groupItemsByIndexTypeFormat(items);
            this.doIndexRules(dbSession, itemsByType.get((Object)RuleIndexDefinition.TYPE_RULE.format())).ifPresent(result::add);
            this.doIndexRuleExtensions(dbSession, itemsByType.get((Object)RuleIndexDefinition.TYPE_RULE_EXTENSION.format())).ifPresent(result::add);
        }
        return result;
    }

    private Optional<IndexingResult> doIndexRules(DbSession dbSession, List<EsQueueDto> items) {
        if (items.isEmpty()) {
            return Optional.empty();
        }
        BulkIndexer bulkIndexer = this.createBulkIndexer(BulkIndexer.Size.REGULAR, new OneToOneResilientIndexingListener(this.dbClient, dbSession, items));
        bulkIndexer.start();
        Set ruleIds = (Set)items.stream().map(i -> Integer.parseInt(i.getDocId())).collect(MoreCollectors.toHashSet((int)items.size()));
        this.dbClient.ruleDao().scrollIndexingRulesByKeys(dbSession, (Collection)ruleIds, r -> {
            bulkIndexer.add(RuleDoc.of(r).toIndexRequest());
            bulkIndexer.add(RuleExtensionDoc.of(r).toIndexRequest());
            ruleIds.remove(r.getId());
        });
        ruleIds.forEach(ruleId -> {
            bulkIndexer.addDeletion(RuleIndexDefinition.TYPE_RULE, ruleId.toString(), ruleId.toString());
            bulkIndexer.addDeletion(RuleIndexDefinition.TYPE_RULE_EXTENSION, RuleExtensionDoc.idOf(ruleId, RuleExtensionScope.system()), ruleId.toString());
        });
        return Optional.of(bulkIndexer.stop());
    }

    private Optional<IndexingResult> doIndexRuleExtensions(DbSession dbSession, List<EsQueueDto> items) {
        if (items.isEmpty()) {
            return Optional.empty();
        }
        BulkIndexer bulkIndexer = this.createBulkIndexer(BulkIndexer.Size.REGULAR, new OneToOneResilientIndexingListener(this.dbClient, dbSession, items));
        bulkIndexer.start();
        Set docIds = (Set)items.stream().map(RuleIndexer::explodeRuleExtensionDocId).collect(MoreCollectors.toHashSet((int)items.size()));
        this.dbClient.ruleDao().scrollIndexingRuleExtensionsByIds(dbSession, (Collection)docIds, r -> {
            RuleExtensionId docId = new RuleExtensionId(r.getOrganizationUuid(), r.getRuleId());
            docIds.remove(docId);
            bulkIndexer.add(RuleExtensionDoc.of(r).toIndexRequest());
        });
        docIds.forEach(docId -> bulkIndexer.addDeletion(RuleIndexDefinition.TYPE_RULE_EXTENSION, docId.getId(), String.valueOf(docId.getRuleId())));
        return Optional.of(bulkIndexer.stop());
    }

    private BulkIndexer createBulkIndexer(BulkIndexer.Size bulkSize, IndexingListener listener) {
        return new BulkIndexer(this.esClient, RuleIndexDefinition.TYPE_RULE, bulkSize, listener);
    }

    private static ListMultimap<String, EsQueueDto> groupItemsByIndexTypeFormat(Collection<EsQueueDto> items) {
        return (ListMultimap)items.stream().collect(MoreCollectors.index(EsQueueDto::getDocType));
    }

    private static RuleExtensionId explodeRuleExtensionDocId(EsQueueDto esQueueDto) {
        Preconditions.checkArgument((boolean)RuleIndexDefinition.TYPE_RULE_EXTENSION.format().equals(esQueueDto.getDocType()));
        return new RuleExtensionId(esQueueDto.getDocId());
    }

    private static EsQueueDto createQueueDtoForRule(int ruleId) {
        String docId = String.valueOf(ruleId);
        return EsQueueDto.create((String)RuleIndexDefinition.TYPE_RULE.format(), (String)docId, null, (String)docId);
    }

    private static EsQueueDto createQueueDtoForRuleExtension(int ruleId, OrganizationDto organization) {
        String docId = RuleExtensionDoc.idOf(ruleId, RuleExtensionScope.organization(organization));
        return EsQueueDto.create((String)RuleIndexDefinition.TYPE_RULE_EXTENSION.format(), (String)docId, null, (String)String.valueOf(ruleId));
    }
}

