/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.security;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class SecurityStandardHelper {
    public static final String UNKNOWN_STANDARD = "unknown";
    public static final String SANS_TOP_25_INSECURE_INTERACTION = "insecure-interaction";
    public static final String SANS_TOP_25_RISKY_RESOURCE = "risky-resource";
    public static final String SANS_TOP_25_POROUS_DEFENSES = "porous-defenses";
    private static final String OWASP_TOP10_PREFIX = "owaspTop10:";
    private static final String CWE_PREFIX = "cwe:";
    private static final Set<String> INSECURE_CWE = new HashSet<String>(Arrays.asList("89", "78", "79", "434", "352", "601"));
    private static final Set<String> RISKY_CWE = new HashSet<String>(Arrays.asList("120", "22", "494", "829", "676", "131", "134", "190"));
    private static final Set<String> POROUS_CWE = new HashSet<String>(Arrays.asList("306", "862", "798", "311", "807", "250", "863", "732", "327", "307", "759"));
    public static final Map<String, Set<String>> SANS_TOP_25_CWE_MAPPING = ImmutableMap.of((Object)"insecure-interaction", INSECURE_CWE, (Object)"risky-resource", RISKY_CWE, (Object)"porous-defenses", POROUS_CWE);
    public static final Map<String, Set<String>> SONARSOURCE_CWE_MAPPING = ImmutableMap.builder().put((Object)"sql-injection", (Object)ImmutableSet.of((Object)"89", (Object)"564")).put((Object)"command-injection", (Object)ImmutableSet.of((Object)"77", (Object)"78", (Object)"88", (Object)"214")).put((Object)"path-traversal-injection", (Object)ImmutableSet.of((Object)"22")).put((Object)"ldap-injection", (Object)ImmutableSet.of((Object)"90")).put((Object)"xpath-injection", (Object)ImmutableSet.of((Object)"643")).put((Object)"rce", (Object)ImmutableSet.of((Object)"94", (Object)"95")).put((Object)"dos", (Object)ImmutableSet.of((Object)"400", (Object)"624")).put((Object)"ssrf", (Object)ImmutableSet.of((Object)"918")).put((Object)"csrf", (Object)ImmutableSet.of((Object)"352")).put((Object)"xss", (Object)ImmutableSet.of((Object)"79", (Object)"80", (Object)"81", (Object)"82", (Object)"83", (Object)"84", (Object[])new String[]{"85", "86", "87"})).put((Object)"log-injection", (Object)ImmutableSet.of((Object)"117")).put((Object)"http-response-splitting", (Object)ImmutableSet.of((Object)"113")).put((Object)"open-redirect", (Object)ImmutableSet.of((Object)"601")).put((Object)"xxe", (Object)ImmutableSet.of((Object)"611", (Object)"827")).put((Object)"object-injection", (Object)ImmutableSet.of((Object)"134", (Object)"470", (Object)"502")).put((Object)"weak-cryptography", (Object)ImmutableSet.of((Object)"295", (Object)"297", (Object)"321", (Object)"322", (Object)"323", (Object)"324", (Object[])new String[]{"325", "326", "327", "328", "330", "780"})).put((Object)"auth", (Object)ImmutableSet.of((Object)"798", (Object)"640", (Object)"620", (Object)"549", (Object)"522", (Object)"521", (Object[])new String[]{"263", "262", "261", "259", "284"})).put((Object)"insecure-conf", (Object)ImmutableSet.of((Object)"102", (Object)"215", (Object)"311", (Object)"315", (Object)"346", (Object)"614", (Object[])new String[]{"489", "942"})).put((Object)"file-manipulation", (Object)ImmutableSet.of((Object)"97", (Object)"73")).build();
    public static final String SONARSOURCE_OTHER_CWES_CATEGORY = "others";
    public static final Ordering<String> SONARSOURCE_CATEGORY_ORDERING = Ordering.explicit((List)ImmutableList.builder().addAll(SONARSOURCE_CWE_MAPPING.keySet()).add((Object)"others").build());
    private static final Splitter SECURITY_STANDARDS_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();

    private SecurityStandardHelper() {
    }

    public static List<String> getSecurityStandards(@Nullable String securityStandards) {
        return securityStandards == null ? Collections.emptyList() : SECURITY_STANDARDS_SPLITTER.splitToList((CharSequence)securityStandards);
    }

    public static List<String> getSansTop25(Collection<String> cwe) {
        return SANS_TOP_25_CWE_MAPPING.keySet().stream().filter(k -> cwe.stream().anyMatch(SANS_TOP_25_CWE_MAPPING.get(k)::contains)).collect(Collectors.toList());
    }

    public static List<String> getSonarSourceSecurityCategories(Collection<String> cwe) {
        List result = SONARSOURCE_CWE_MAPPING.keySet().stream().filter(k -> cwe.stream().anyMatch(SONARSOURCE_CWE_MAPPING.get(k)::contains)).collect(Collectors.toList());
        return result.isEmpty() ? Collections.singletonList(SONARSOURCE_OTHER_CWES_CATEGORY) : result;
    }

    public static List<String> getOwaspTop10(Collection<String> securityStandards) {
        return securityStandards.stream().filter(s -> s.startsWith(OWASP_TOP10_PREFIX)).map(s -> s.substring(OWASP_TOP10_PREFIX.length())).collect(Collectors.toList());
    }

    public static List<String> getCwe(Collection<String> securityStandards) {
        List result = securityStandards.stream().filter(s -> s.startsWith(CWE_PREFIX)).map(s -> s.substring(CWE_PREFIX.length())).collect(Collectors.toList());
        return result.isEmpty() ? Collections.singletonList(UNKNOWN_STANDARD) : result;
    }

    public static List<String> getSansTop25(String securityStandards) {
        return SecurityStandardHelper.getSansTop25(SecurityStandardHelper.getCwe(SecurityStandardHelper.getSecurityStandards(securityStandards)));
    }

    public static List<String> getSonarSourceSecurityCategories(String securityStandards) {
        return SecurityStandardHelper.getSonarSourceSecurityCategories(SecurityStandardHelper.getCwe(SecurityStandardHelper.getSecurityStandards(securityStandards)));
    }

    public static List<String> getOwaspTop10(String securityStandards) {
        return SecurityStandardHelper.getOwaspTop10(SecurityStandardHelper.getSecurityStandards(securityStandards));
    }

    public static List<String> getCwe(String securityStandards) {
        return SecurityStandardHelper.getCwe(SecurityStandardHelper.getSecurityStandards(securityStandards));
    }
}

