/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user.index;

import org.sonar.api.config.Configuration;
import org.sonar.api.config.internal.MapSettings;
import org.sonar.server.es.Index;
import org.sonar.server.es.IndexDefinition;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.newindex.DefaultIndexSettingsElement;
import org.sonar.server.es.newindex.KeywordFieldBuilder;
import org.sonar.server.es.newindex.NewRegularIndex;
import org.sonar.server.es.newindex.SettingsConfiguration;
import org.sonar.server.es.newindex.TypeMapping;

public class UserIndexDefinition
implements IndexDefinition {
    public static final Index DESCRIPTOR = Index.simple("users");
    public static final IndexType.IndexMainType TYPE_USER = IndexType.main(DESCRIPTOR, "user");
    public static final String FIELD_UUID = "uuid";
    public static final String FIELD_LOGIN = "login";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_EMAIL = "email";
    public static final String FIELD_ACTIVE = "active";
    public static final String FIELD_SCM_ACCOUNTS = "scmAccounts";
    public static final String FIELD_ORGANIZATION_UUIDS = "organizationUuids";
    private final Configuration config;

    public UserIndexDefinition(Configuration config) {
        this.config = config;
    }

    public static UserIndexDefinition createForTest() {
        return new UserIndexDefinition(new MapSettings().asConfig());
    }

    @Override
    public void define(IndexDefinition.IndexDefinitionContext context) {
        NewRegularIndex index = (NewRegularIndex)context.create(DESCRIPTOR, SettingsConfiguration.newBuilder(this.config).setDefaultNbOfShards(1).build()).setEnableSource(true);
        TypeMapping mapping = index.createTypeMapping(TYPE_USER);
        ((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_UUID).disableNorms()).build();
        ((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_LOGIN).addSubFields(DefaultIndexSettingsElement.USER_SEARCH_GRAMS_ANALYZER)).build();
        ((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_NAME).addSubFields(DefaultIndexSettingsElement.USER_SEARCH_GRAMS_ANALYZER)).build();
        ((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_EMAIL).addSubFields(DefaultIndexSettingsElement.USER_SEARCH_GRAMS_ANALYZER, DefaultIndexSettingsElement.SORTABLE_ANALYZER)).build();
        mapping.createBooleanField(FIELD_ACTIVE);
        ((KeywordFieldBuilder)((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_SCM_ACCOUNTS).disableNorms()).addSubFields(DefaultIndexSettingsElement.SORTABLE_ANALYZER)).build();
        ((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_ORGANIZATION_UUIDS).disableNorms()).build();
    }
}

