/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.queue;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.queue.CeQueue;
import org.sonar.ce.queue.CeTaskSubmit;
import org.sonar.ce.task.CeTask;
import org.sonar.core.util.UuidFactory;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.ce.CeActivityDto;
import org.sonar.db.ce.CeQueueDto;
import org.sonar.db.ce.CeTaskCharacteristicDto;
import org.sonar.db.ce.DeleteIf;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.organization.DefaultOrganizationProvider;

@ServerSide
public class CeQueueImpl
implements CeQueue {
    private final System2 system2;
    private final DbClient dbClient;
    private final UuidFactory uuidFactory;
    private final DefaultOrganizationProvider defaultOrganizationProvider;

    public CeQueueImpl(System2 system2, DbClient dbClient, UuidFactory uuidFactory, DefaultOrganizationProvider defaultOrganizationProvider) {
        this.system2 = system2;
        this.dbClient = dbClient;
        this.uuidFactory = uuidFactory;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
    }

    @Override
    public CeTaskSubmit.Builder prepareSubmit() {
        return new CeTaskSubmit.Builder(this.uuidFactory.create());
    }

    @Override
    public CeTask submit(CeTaskSubmit submission) {
        return this.submit(submission, EnumSet.noneOf(CeQueue.SubmitOption.class)).get();
    }

    @Override
    public Optional<CeTask> submit(CeTaskSubmit submission, CeQueue.SubmitOption ... options) {
        return this.submit(submission, CeQueueImpl.toSet(options));
    }

    private Optional<CeTask> submit(CeTaskSubmit submission, EnumSet<CeQueue.SubmitOption> submitOptions) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            if (submitOptions.contains((Object)CeQueue.SubmitOption.UNIQUE_QUEUE_PER_MAIN_COMPONENT) && submission.getComponent().map(component -> this.dbClient.ceQueueDao().countByStatusAndMainComponentUuid(dbSession, CeQueueDto.Status.PENDING, component.getMainComponentUuid()) > 0).orElse(false).booleanValue()) {
                Optional<CeTask> optional = Optional.empty();
                return optional;
            }
            CeQueueDto taskDto = this.addToQueueInDb(dbSession, submission);
            dbSession.commit();
            Map<String, ComponentDto> componentsByUuid = this.loadComponentDtos(dbSession, taskDto);
            if (componentsByUuid.isEmpty()) {
                Optional<CeTask> optional = Optional.of(this.convertToTask(dbSession, taskDto, submission.getCharacteristics(), null, null));
                return optional;
            }
            Optional<CeTask> optional = Optional.of(this.convertToTask(dbSession, taskDto, submission.getCharacteristics(), Optional.ofNullable(taskDto.getComponentUuid()).map(componentsByUuid::get).orElse(null), Optional.ofNullable(taskDto.getMainComponentUuid()).map(componentsByUuid::get).orElse(null)));
            return optional;
        }
    }

    Map<String, ComponentDto> loadComponentDtos(DbSession dbSession, CeQueueDto taskDto) {
        Set componentUuids = (Set)Stream.of(taskDto.getComponentUuid(), taskDto.getMainComponentUuid()).filter(Objects::nonNull).collect(MoreCollectors.toSet((int)2));
        if (componentUuids.isEmpty()) {
            return Collections.emptyMap();
        }
        return (Map)this.dbClient.componentDao().selectByUuids(dbSession, (Collection)componentUuids).stream().collect(MoreCollectors.uniqueIndex(ComponentDto::uuid, (int)2));
    }

    @Override
    public List<CeTask> massSubmit(Collection<CeTaskSubmit> submissions, CeQueue.SubmitOption ... options) {
        if (submissions.isEmpty()) {
            return Collections.emptyList();
        }
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List<CeQueueDto> taskDtos = submissions.stream().filter(this.filterBySubmitOptions(options, submissions, dbSession)).map(submission -> this.addToQueueInDb(dbSession, (CeTaskSubmit)submission)).collect(Collectors.toList());
            List<CeTask> tasks = this.loadTasks(dbSession, taskDtos);
            dbSession.commit();
            List<CeTask> list = tasks;
            return list;
        }
    }

    private Predicate<CeTaskSubmit> filterBySubmitOptions(CeQueue.SubmitOption[] options, Collection<CeTaskSubmit> submissions, DbSession dbSession) {
        EnumSet<CeQueue.SubmitOption> submitOptions = CeQueueImpl.toSet(options);
        if (submitOptions.contains((Object)CeQueue.SubmitOption.UNIQUE_QUEUE_PER_MAIN_COMPONENT)) {
            Set mainComponentUuids = (Set)submissions.stream().map(CeTaskSubmit::getComponent).filter(Optional::isPresent).map(Optional::get).map(CeTaskSubmit.Component::getMainComponentUuid).collect(MoreCollectors.toSet((int)submissions.size()));
            if (mainComponentUuids.isEmpty()) {
                return t -> true;
            }
            return new NoPendingTaskFilter(dbSession, mainComponentUuids);
        }
        return t -> true;
    }

    private static EnumSet<CeQueue.SubmitOption> toSet(CeQueue.SubmitOption[] options) {
        return (EnumSet)Arrays.stream(options).collect(MoreCollectors.toEnumSet(CeQueue.SubmitOption.class));
    }

    private CeQueueDto addToQueueInDb(DbSession dbSession, CeTaskSubmit submission) {
        for (Map.Entry<String, String> characteristic : submission.getCharacteristics().entrySet()) {
            CeTaskCharacteristicDto characteristicDto = new CeTaskCharacteristicDto();
            characteristicDto.setUuid(this.uuidFactory.create());
            characteristicDto.setTaskUuid(submission.getUuid());
            characteristicDto.setKey(characteristic.getKey());
            characteristicDto.setValue(characteristic.getValue());
            this.dbClient.ceTaskCharacteristicsDao().insert(dbSession, characteristicDto);
        }
        CeQueueDto dto = new CeQueueDto();
        dto.setUuid(submission.getUuid());
        dto.setTaskType(submission.getType());
        submission.getComponent().ifPresent(component -> dto.setComponentUuid(component.getUuid()).setMainComponentUuid(component.getMainComponentUuid()));
        dto.setStatus(CeQueueDto.Status.PENDING);
        dto.setSubmitterUuid(submission.getSubmitterUuid());
        this.dbClient.ceQueueDao().insert(dbSession, dto);
        return dto;
    }

    private List<CeTask> loadTasks(DbSession dbSession, List<CeQueueDto> dtos) {
        Set componentUuids = dtos.stream().flatMap(dto -> Stream.of(dto.getComponentUuid(), dto.getMainComponentUuid())).filter(Objects::nonNull).collect(Collectors.toSet());
        Map componentsByUuid = (Map)this.dbClient.componentDao().selectByUuids(dbSession, componentUuids).stream().collect(MoreCollectors.uniqueIndex(ComponentDto::uuid));
        Set taskUuids = (Set)dtos.stream().map(CeQueueDto::getUuid).collect(MoreCollectors.toSet((int)dtos.size()));
        Multimap characteristicsByTaskUuid = (Multimap)this.dbClient.ceTaskCharacteristicsDao().selectByTaskUuids(dbSession, (Collection)taskUuids).stream().collect(MoreCollectors.index(CeTaskCharacteristicDto::getTaskUuid));
        ArrayList<CeTask> result = new ArrayList<CeTask>();
        for (CeQueueDto dto2 : dtos) {
            ComponentDto component = Optional.ofNullable(dto2.getComponentUuid()).map(componentsByUuid::get).orElse(null);
            ComponentDto mainComponent = Optional.ofNullable(dto2.getMainComponentUuid()).map(componentsByUuid::get).orElse(null);
            Map characteristics = (Map)characteristicsByTaskUuid.get((Object)dto2.getUuid()).stream().collect(MoreCollectors.uniqueIndex(CeTaskCharacteristicDto::getKey, CeTaskCharacteristicDto::getValue));
            result.add(this.convertToTask(dbSession, dto2, characteristics, component, mainComponent));
        }
        return result;
    }

    @Override
    public void cancel(DbSession dbSession, CeQueueDto ceQueueDto) {
        Preconditions.checkState((boolean)CeQueueDto.Status.PENDING.equals((Object)ceQueueDto.getStatus()), (String)"Task is in progress and can't be canceled [uuid=%s]", (Object[])new Object[]{ceQueueDto.getUuid()});
        this.cancelImpl(dbSession, ceQueueDto);
    }

    private void cancelImpl(DbSession dbSession, CeQueueDto q) {
        CeActivityDto activityDto = new CeActivityDto(q);
        activityDto.setStatus(CeActivityDto.Status.CANCELED);
        this.remove(dbSession, q, activityDto);
    }

    @Override
    public void fail(DbSession dbSession, CeQueueDto task, @Nullable String errorType, @Nullable String errorMessage) {
        Preconditions.checkState((boolean)CeQueueDto.Status.IN_PROGRESS.equals((Object)task.getStatus()), (String)"Task is not in-progress and can't be marked as failed [uuid=%s]", (Object[])new Object[]{task.getUuid()});
        CeActivityDto activityDto = new CeActivityDto(task);
        activityDto.setStatus(CeActivityDto.Status.FAILED);
        activityDto.setErrorType(errorType);
        activityDto.setErrorMessage(errorMessage);
        this.updateExecutionFields(activityDto);
        this.remove(dbSession, task, activityDto);
    }

    protected long updateExecutionFields(CeActivityDto activityDto) {
        Long startedAt = activityDto.getStartedAt();
        if (startedAt == null) {
            return 0L;
        }
        long now = this.system2.now();
        long executionTimeInMs = now - startedAt;
        activityDto.setExecutedAt(Long.valueOf(now));
        activityDto.setExecutionTimeMs(Long.valueOf(executionTimeInMs));
        return executionTimeInMs;
    }

    protected void remove(DbSession dbSession, CeQueueDto queueDto, CeActivityDto activityDto) {
        String taskUuid = queueDto.getUuid();
        CeQueueDto.Status expectedQueueDtoStatus = queueDto.getStatus();
        this.dbClient.ceActivityDao().insert(dbSession, activityDto);
        this.dbClient.ceTaskInputDao().deleteByUuids(dbSession, Collections.singleton(taskUuid));
        int deletedTasks = this.dbClient.ceQueueDao().deleteByUuid(dbSession, taskUuid, new DeleteIf(expectedQueueDtoStatus));
        if (deletedTasks == 1) {
            dbSession.commit();
        } else {
            Loggers.get(CeQueueImpl.class).debug("Remove rolled back because task in queue with uuid {} and status {} could not be deleted", (Object)taskUuid, (Object)expectedQueueDtoStatus);
            dbSession.rollback();
        }
    }

    @Override
    public int cancelAll() {
        return this.cancelAll(false);
    }

    int cancelAll(boolean includeInProgress) {
        int count = 0;
        try (DbSession dbSession = this.dbClient.openSession(false);){
            for (CeQueueDto queueDto : this.dbClient.ceQueueDao().selectAllInAscOrder(dbSession)) {
                if (!includeInProgress && queueDto.getStatus().equals((Object)CeQueueDto.Status.IN_PROGRESS)) continue;
                this.cancelImpl(dbSession, queueDto);
                ++count;
            }
            int n = count;
            return n;
        }
    }

    @Override
    public void pauseWorkers() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.dbClient.internalPropertiesDao().save(dbSession, "ce.pause", "true");
            dbSession.commit();
        }
    }

    @Override
    public void resumeWorkers() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.dbClient.internalPropertiesDao().delete(dbSession, "ce.pause");
            dbSession.commit();
        }
    }

    @Override
    public CeQueue.WorkersPauseStatus getWorkersPauseStatus() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Optional propValue = this.dbClient.internalPropertiesDao().selectByKey(dbSession, "ce.pause");
            if (!propValue.isPresent() || !((String)propValue.get()).equals("true")) {
                CeQueue.WorkersPauseStatus workersPauseStatus = CeQueue.WorkersPauseStatus.RESUMED;
                return workersPauseStatus;
            }
            int countInProgress = this.dbClient.ceQueueDao().countByStatus(dbSession, CeQueueDto.Status.IN_PROGRESS);
            if (countInProgress > 0) {
                CeQueue.WorkersPauseStatus workersPauseStatus = CeQueue.WorkersPauseStatus.PAUSING;
                return workersPauseStatus;
            }
            CeQueue.WorkersPauseStatus workersPauseStatus = CeQueue.WorkersPauseStatus.PAUSED;
            return workersPauseStatus;
        }
    }

    CeTask convertToTask(DbSession dbSession, CeQueueDto taskDto, Map<String, String> characteristics, @Nullable ComponentDto component, @Nullable ComponentDto mainComponent) {
        CeTask.Builder builder = new CeTask.Builder().setUuid(taskDto.getUuid()).setType(taskDto.getTaskType()).setCharacteristics(characteristics).setSubmitter(this.resolveSubmitter(dbSession, taskDto.getSubmitterUuid()));
        String componentUuid = taskDto.getComponentUuid();
        if (component != null) {
            builder.setComponent(new CeTask.Component(component.uuid(), component.getDbKey(), component.name()));
            builder.setOrganizationUuid(component.getOrganizationUuid());
        } else if (componentUuid != null) {
            builder.setComponent(new CeTask.Component(componentUuid, null, null));
        }
        String mainComponentUuid = taskDto.getMainComponentUuid();
        if (mainComponent != null) {
            builder.setMainComponent(new CeTask.Component(mainComponent.uuid(), mainComponent.getDbKey(), mainComponent.name()));
        } else if (mainComponentUuid != null) {
            builder.setMainComponent(new CeTask.Component(mainComponentUuid, null, null));
        }
        if (!builder.hasOrganizationUuid()) {
            builder.setOrganizationUuid(this.defaultOrganizationProvider.get().getUuid());
        }
        return builder.build();
    }

    @CheckForNull
    private CeTask.User resolveSubmitter(DbSession dbSession, @Nullable String submitterUuid) {
        if (submitterUuid == null) {
            return null;
        }
        UserDto submitterDto = this.dbClient.userDao().selectByUuid(dbSession, submitterUuid);
        if (submitterDto != null) {
            return new CeTask.User(submitterUuid, submitterDto.getLogin());
        }
        return new CeTask.User(submitterUuid, null);
    }

    private class NoPendingTaskFilter
    implements Predicate<CeTaskSubmit> {
        private final Map<String, Integer> queuedItemsByMainComponentUuid;

        private NoPendingTaskFilter(DbSession dbSession, Set<String> projectUuids) {
            this.queuedItemsByMainComponentUuid = CeQueueImpl.this.dbClient.ceQueueDao().countByStatusAndMainComponentUuids(dbSession, CeQueueDto.Status.PENDING, projectUuids);
        }

        @Override
        public boolean test(CeTaskSubmit ceTaskSubmit) {
            return ceTaskSubmit.getComponent().map(component -> this.queuedItemsByMainComponentUuid.getOrDefault(component.getMainComponentUuid(), 0) == 0).orElse(true);
        }
    }
}

