/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.auth.github;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.extractors.OAuth2AccessTokenExtractor;
import com.github.scribejava.core.extractors.TokenExtractor;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.Verb;
import java.util.Map;
import java.util.Objects;
import org.sonar.api.server.ServerSide;
import org.sonarsource.auth.github.GitHubSettings;

@ServerSide
public class ScribeGitHubApi
extends DefaultApi20 {
    private final GitHubSettings settings;

    public ScribeGitHubApi(GitHubSettings settings) {
        this.settings = settings;
    }

    public Verb getAccessTokenVerb() {
        return Verb.POST;
    }

    public String getAccessTokenEndpoint() {
        return this.settings.webURL() + "login/oauth/access_token";
    }

    protected String getAuthorizationBaseUrl() {
        return this.settings.webURL() + "login/oauth/authorize";
    }

    public TokenExtractor<OAuth2AccessToken> getAccessTokenExtractor() {
        return OAuth2AccessTokenExtractor.instance();
    }

    public String getAuthorizationUrl(OAuthConfig config, Map<String, String> additionalParams) {
        Objects.requireNonNull(config.getCallback(), "URL for callback should not be null.");
        Objects.requireNonNull(config.getApiKey(), "ApiKey should not be null.");
        Objects.requireNonNull(config.getScope(), "Scope should not be null.");
        Objects.requireNonNull(config.getState(), "State should not be null.");
        return super.getAuthorizationUrl(config, additionalParams);
    }
}

