/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.auth.github;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.SonarRuntime;
import org.sonar.api.server.authentication.UserIdentity;
import org.sonar.api.utils.Version;
import org.sonarsource.auth.github.GitHubSettings;
import org.sonarsource.auth.github.GsonTeams;
import org.sonarsource.auth.github.GsonUser;
import org.sonarsource.auth.github.UserIdentityFactory;
import org.sonarsource.auth.github.UserIdentityGenerator;

public class UserIdentityFactoryImpl
implements UserIdentityFactory {
    private final GitHubSettings settings;
    private final SonarRuntime sonarRuntime;

    public UserIdentityFactoryImpl(GitHubSettings settings, SonarRuntime sonarRuntime) {
        this.settings = settings;
        this.sonarRuntime = sonarRuntime;
    }

    @Override
    public UserIdentity create(GsonUser user, @Nullable String email, @Nullable List<GsonTeams.GsonTeam> teams) {
        UserIdentity.Builder builder = UserIdentity.builder().setProviderLogin(user.getLogin()).setLogin(UserIdentityGenerator.generateLogin(user, this.settings.loginStrategy())).setName(UserIdentityGenerator.generateName(user)).setEmail(email);
        if (teams != null) {
            builder.setGroups(teams.stream().map(team -> team.getOrganizationId() + "/" + team.getId()).collect(Collectors.toSet()));
        }
        if (this.sonarRuntime.getApiVersion().isGreaterThanOrEqual(Version.create((int)7, (int)2))) {
            builder.setProviderId(user.getId());
        }
        return builder.build();
    }
}

