/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.issue.internal;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.issue.IssueLocation;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.internal.AbstractDefaultIssue;
import org.sonar.api.rule.RuleKey;

public class DefaultIssue
extends AbstractDefaultIssue<DefaultIssue>
implements Issue,
NewIssue {
    private RuleKey ruleKey;
    private Double gap;
    private Severity overriddenSeverity;

    public DefaultIssue(DefaultInputProject project) {
        this(project, null);
    }

    public DefaultIssue(DefaultInputProject project, @Nullable SensorStorage storage) {
        super(project, storage);
    }

    @Override
    public DefaultIssue forRule(RuleKey ruleKey) {
        this.ruleKey = ruleKey;
        return this;
    }

    @Override
    public RuleKey ruleKey() {
        return this.ruleKey;
    }

    @Override
    public DefaultIssue gap(@Nullable Double gap) {
        Preconditions.checkArgument((gap == null || gap >= 0.0 ? 1 : 0) != 0, (Object)String.format("Gap must be greater than or equal 0 (got %s)", gap));
        this.gap = gap;
        return this;
    }

    @Override
    public DefaultIssue overrideSeverity(@Nullable Severity severity) {
        this.overriddenSeverity = severity;
        return this;
    }

    @Override
    public Severity overriddenSeverity() {
        return this.overriddenSeverity;
    }

    @Override
    public Double gap() {
        return this.gap;
    }

    @Override
    public IssueLocation primaryLocation() {
        return this.primaryLocation;
    }

    @Override
    public void doSave() {
        Objects.requireNonNull(this.ruleKey, "ruleKey is mandatory on issue");
        Preconditions.checkState((this.primaryLocation != null ? 1 : 0) != 0, (Object)"Primary location is mandatory on every issue");
        this.storage.store(this);
    }
}

