/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.SystemUtils;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.server.ServerSide;

@ScannerSide
@ServerSide
@ComputeEngineSide
public class System2 {
    public static final System2 INSTANCE = new System2();

    public long now() {
        return System.currentTimeMillis();
    }

    public Properties properties() {
        return System.getProperties();
    }

    @CheckForNull
    public String property(String key) {
        return System.getProperty(key);
    }

    public System2 setProperty(String key, String value) {
        System.setProperty(key, value);
        return this;
    }

    public Map<String, String> envVariables() {
        return System.getenv();
    }

    @CheckForNull
    public String envVariable(String key) {
        return System.getenv(key);
    }

    public boolean isOsWindows() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    @Deprecated
    public boolean isJavaAtLeast17() {
        return true;
    }

    public void println(String obj) {
        System.out.print(obj);
    }

    public TimeZone getDefaultTimeZone() {
        return TimeZone.getDefault();
    }

    public URL getResource(String name) {
        return this.getClass().getResource(name);
    }

    public void close(AutoCloseable closeable) {
        try {
            closeable.close();
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to close " + closeable, e);
        }
    }
}

