/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.issue;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class FieldDiffs
implements Serializable {
    public static final Splitter FIELDS_SPLITTER = Splitter.on((char)',').omitEmptyStrings();
    private static final String CHAR_TO_ESCAPE = "|,{}=:";
    private String issueKey;
    private String userUuid;
    private Date creationDate;
    public static final String ASSIGNEE = "assignee";
    public static final String ENCODING_PREFIX = "{base64:";
    public static final String ENCODING_SUFFIX = "}";
    private final Map<String, Diff> diffs = Maps.newLinkedHashMap();

    public Map<String, Diff> diffs() {
        if (this.diffs.containsKey(ASSIGNEE)) {
            LinkedHashMap result = Maps.newLinkedHashMap(this.diffs);
            result.put(ASSIGNEE, this.decode((Diff)result.get(ASSIGNEE)));
            return result;
        }
        return this.diffs;
    }

    public Diff get(String field) {
        if (field.equals(ASSIGNEE)) {
            return this.decode(this.diffs.get(ASSIGNEE));
        }
        return this.diffs.get(field);
    }

    @CheckForNull
    public String userUuid() {
        return this.userUuid;
    }

    public FieldDiffs setUserUuid(@Nullable String s) {
        this.userUuid = s;
        return this;
    }

    public Date creationDate() {
        return this.creationDate;
    }

    public FieldDiffs setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    public String issueKey() {
        return this.issueKey;
    }

    public FieldDiffs setIssueKey(String issueKey) {
        this.issueKey = issueKey;
        return this;
    }

    public FieldDiffs setDiff(String field, @Nullable Serializable oldValue, @Nullable Serializable newValue) {
        Diff<Serializable> diff = this.diffs.get(field);
        if (field.equals(ASSIGNEE)) {
            oldValue = FieldDiffs.encodeField(oldValue);
            newValue = FieldDiffs.encodeField(newValue);
        }
        if (diff == null) {
            diff = new Diff<Serializable>(oldValue, newValue);
            this.diffs.put(field, diff);
        } else {
            diff.setNewValue(newValue);
        }
        return this;
    }

    public String toEncodedString() {
        return this.serialize(true);
    }

    public String toString() {
        return this.serialize(false);
    }

    private String serialize(boolean shouldEncode) {
        StringBuilder sb = new StringBuilder();
        boolean notFirst = false;
        for (Map.Entry<String, Diff> entry : this.diffs.entrySet()) {
            if (notFirst) {
                sb.append(',');
            } else {
                notFirst = true;
            }
            sb.append(entry.getKey());
            sb.append('=');
            if (shouldEncode) {
                sb.append(entry.getValue().toEncodedString());
                continue;
            }
            sb.append(entry.getValue().toString());
        }
        return sb.toString();
    }

    public static FieldDiffs parse(@Nullable String s) {
        FieldDiffs diffs = new FieldDiffs();
        if (Strings.isNullOrEmpty((String)s)) {
            return diffs;
        }
        Iterable fields = FIELDS_SPLITTER.split((CharSequence)s);
        for (String field : fields) {
            String[] keyValues = field.split("=", 2);
            if (keyValues.length == 2) {
                String values = keyValues[1];
                int split = values.indexOf(124);
                if (split > -1) {
                    diffs.setDiff(keyValues[0], (Serializable)((Object)Strings.emptyToNull((String)values.substring(0, split))), (Serializable)((Object)Strings.emptyToNull((String)values.substring(split + 1))));
                    continue;
                }
                diffs.setDiff(keyValues[0], null, (Serializable)((Object)Strings.emptyToNull((String)values)));
                continue;
            }
            diffs.setDiff(keyValues[0], null, null);
        }
        return diffs;
    }

    Diff decode(Diff encoded) {
        return new Diff<Serializable>(FieldDiffs.decodeField(encoded.oldValue), FieldDiffs.decodeField(encoded.newValue));
    }

    private static Serializable decodeField(@Nullable Serializable field) {
        if (field == null || !FieldDiffs.isEncoded(field)) {
            return field;
        }
        String encodedField = field.toString();
        String value = encodedField.substring(ENCODING_PREFIX.length(), encodedField.indexOf(ENCODING_SUFFIX));
        return new String(Base64.getDecoder().decode(value), StandardCharsets.UTF_8);
    }

    private static Serializable encodeField(@Nullable Serializable field) {
        if (field == null || !FieldDiffs.shouldEncode(field.toString())) {
            return field;
        }
        return ENCODING_PREFIX + Base64.getEncoder().encodeToString(field.toString().getBytes(StandardCharsets.UTF_8)) + ENCODING_SUFFIX;
    }

    private static boolean shouldEncode(String field) {
        return !field.isEmpty() && !FieldDiffs.isEncoded((Serializable)((Object)field)) && FieldDiffs.containsCharToEscape((Serializable)((Object)field));
    }

    private static boolean containsCharToEscape(Serializable s) {
        return StringUtils.containsAny((String)s.toString(), (String)CHAR_TO_ESCAPE);
    }

    private static boolean isEncoded(Serializable field) {
        return field.toString().startsWith(ENCODING_PREFIX) && field.toString().endsWith(ENCODING_SUFFIX);
    }

    public static class Diff<T extends Serializable>
    implements Serializable {
        private T oldValue;
        private T newValue;

        public Diff(@Nullable T oldValue, @Nullable T newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @CheckForNull
        public T oldValue() {
            return this.oldValue;
        }

        @CheckForNull
        public Long oldValueLong() {
            return Diff.toLong(this.oldValue);
        }

        @CheckForNull
        public T newValue() {
            return this.newValue;
        }

        @CheckForNull
        public Long newValueLong() {
            return Diff.toLong(this.newValue);
        }

        void setNewValue(@Nullable T t) {
            this.newValue = t;
        }

        @CheckForNull
        private static Long toLong(@Nullable Serializable value) {
            if (value != null && !"".equals(value)) {
                try {
                    return Long.valueOf((String)((Object)value));
                }
                catch (ClassCastException e) {
                    return (Long)value;
                }
            }
            return null;
        }

        private String toEncodedString() {
            return this.serialize(true);
        }

        public String toString() {
            return this.serialize(false);
        }

        private String serialize(boolean shouldEncode) {
            StringBuilder sb = new StringBuilder();
            if (this.oldValue != null) {
                sb.append(shouldEncode ? this.oldValue : FieldDiffs.decodeField(this.oldValue));
                sb.append('|');
            }
            if (this.newValue != null) {
                sb.append(shouldEncode ? this.newValue : FieldDiffs.decodeField(this.newValue));
            }
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Diff diff = (Diff)o;
            return Objects.equals(this.oldValue, diff.oldValue) && Objects.equals(this.newValue, diff.newValue);
        }

        public int hashCode() {
            return Objects.hash(this.oldValue, this.newValue);
        }
    }
}

