/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application.cluster.health;

import org.sonar.application.cluster.ClusterAppState;
import org.sonar.process.NetworkUtils;
import org.sonar.process.ProcessId;
import org.sonar.process.ProcessProperties;
import org.sonar.process.Props;
import org.sonar.process.cluster.health.NodeDetails;
import org.sonar.process.cluster.health.NodeHealth;
import org.sonar.process.cluster.health.NodeHealthProvider;

public class SearchNodeHealthProvider
implements NodeHealthProvider {
    private final ClusterAppState clusterAppState;
    private final NodeDetails nodeDetails;

    public SearchNodeHealthProvider(Props props, ClusterAppState clusterAppState, NetworkUtils networkUtils) {
        this(props, clusterAppState, networkUtils, new Clock());
    }

    SearchNodeHealthProvider(Props props, ClusterAppState clusterAppState, NetworkUtils networkUtils, Clock clock) {
        this.clusterAppState = clusterAppState;
        this.nodeDetails = NodeDetails.newNodeDetailsBuilder().setType(NodeDetails.Type.SEARCH).setName(props.nonNullValue(ProcessProperties.Property.CLUSTER_NODE_NAME.getKey())).setHost(SearchNodeHealthProvider.getHost(props, networkUtils)).setPort(Integer.valueOf(props.nonNullValue(ProcessProperties.Property.CLUSTER_NODE_HZ_PORT.getKey())).intValue()).setStartedAt(clock.now()).build();
    }

    private static String getHost(Props props, NetworkUtils networkUtils) {
        String host = props.value(ProcessProperties.Property.CLUSTER_NODE_HOST.getKey());
        if (host != null && !host.isEmpty()) {
            return host;
        }
        return networkUtils.getHostname();
    }

    public NodeHealth get() {
        NodeHealth.Builder builder = NodeHealth.newNodeHealthBuilder();
        if (this.clusterAppState.isOperational(ProcessId.ELASTICSEARCH, true)) {
            builder.setStatus(NodeHealth.Status.GREEN);
        } else {
            builder.setStatus(NodeHealth.Status.RED).addCause("Elasticsearch is not operational");
        }
        return builder.setDetails(this.nodeDetails).build();
    }

    static class Clock {
        Clock() {
        }

        long now() {
            return System.currentTimeMillis();
        }
    }
}

