/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v60;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class PopulateComponentUuidOfMeasures
extends DataChange {
    public PopulateComponentUuidOfMeasures(Database db) {
        super(db);
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select distinct pm.snapshot_id, s.component_uuid from project_measures pm inner join snapshots s on s.id=pm.snapshot_id where pm.component_uuid is null");
        massUpdate.update("UPDATE project_measures SET component_uuid=? WHERE snapshot_id=? and component_uuid is null");
        massUpdate.rowPluralName("measures");
        massUpdate.execute(this::handle);
    }

    public boolean handle(Select.Row row, SqlStatement update) throws SQLException {
        long snapshotId = row.getLong(1);
        String componentUuid = row.getString(2);
        update.setString(1, componentUuid);
        update.setLong(2, snapshotId);
        return true;
    }
}

