/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v60;

import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class PopulateProfileKeyOfActivities
extends DataChange {
    public PopulateProfileKeyOfActivities(Database db) {
        super(db);
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select id, data_field from activities where profile_key is null");
        massUpdate.update("update activities set profile_key=?, data_field=? where id=?");
        massUpdate.rowPluralName("activities");
        massUpdate.execute(PopulateProfileKeyOfActivities::handle);
        context.prepareUpsert("delete from activities where profile_key is null").execute().commit();
    }

    private static boolean handle(Select.Row row, SqlStatement update) throws SQLException {
        int id = row.getInt(1);
        String data = row.getString(2);
        Map fields = KeyValueFormat.parse((String)data);
        String profileKey = (String)fields.remove("profileKey");
        if (StringUtils.isBlank((String)profileKey)) {
            return false;
        }
        update.setString(1, profileKey);
        update.setString(2, KeyValueFormat.format((Map)fields));
        update.setInt(3, id);
        return true;
    }
}

