/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v63;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.Upsert;
import org.sonar.server.platform.db.migration.version.v63.DefaultOrganizationUuidProvider;

public class PopulateDefaultPermTemplateColumnsOfOrganizations
extends DataChange {
    private static final String DEFAULT_TEMPLATE_PROPERTY = "sonar.permission.template.default";
    private static final String DEFAULT_PROJECT_TEMPLATE_PROPERTY = "sonar.permission.template.TRK.default";
    private static final String DEFAULT_VIEW_TEMPLATE_PROPERTY = "sonar.permission.template.VW.default";
    private static final String DEFAULT_DEV_TEMPLATE_PROPERTY = "sonar.permission.template.DEV.default";
    private final DefaultOrganizationUuidProvider defaultOrganizationUuid;
    private final UuidFactory uuidFactory;

    public PopulateDefaultPermTemplateColumnsOfOrganizations(Database db, DefaultOrganizationUuidProvider defaultOrganizationUuid, UuidFactory uuidFactory) {
        super(db);
        this.defaultOrganizationUuid = defaultOrganizationUuid;
        this.uuidFactory = uuidFactory;
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        String defaultOrganizationUuid = this.defaultOrganizationUuid.getAndCheck(context);
        PopulateDefaultPermTemplateColumnsOfOrganizations.ensureOnlyDefaultOrganizationExists(context, defaultOrganizationUuid);
        Map<String, String> defaultTemplateProperties = PopulateDefaultPermTemplateColumnsOfOrganizations.retrieveDefaultTemplateProperties(context);
        String globalDefaultTemplate = defaultTemplateProperties.get(DEFAULT_TEMPLATE_PROPERTY);
        if (globalDefaultTemplate == null || globalDefaultTemplate.isEmpty()) {
            return;
        }
        String projectDefaultTemplate = this.updateKeeIfRequired(context, (String)MoreObjects.firstNonNull((Object)defaultTemplateProperties.get(DEFAULT_PROJECT_TEMPLATE_PROPERTY), (Object)globalDefaultTemplate));
        String viewDefaultTemplate = this.updateKeeIfRequired(context, defaultTemplateProperties.get(DEFAULT_VIEW_TEMPLATE_PROPERTY));
        Loggers.get(PopulateDefaultPermTemplateColumnsOfOrganizations.class).debug("Setting default templates on default organization '{}': project='{}', view='{}'", new Object[]{defaultOrganizationUuid, projectDefaultTemplate, viewDefaultTemplate});
        ((Upsert)((Upsert)((Upsert)context.prepareUpsert("update organizations set default_perm_template_project=?, default_perm_template_view=? where uuid=?").setString(1, projectDefaultTemplate)).setString(2, viewDefaultTemplate)).setString(3, defaultOrganizationUuid)).execute().commit();
        ((Upsert)((Upsert)((Upsert)((Upsert)context.prepareUpsert("delete from properties where prop_key in (?,?,?,?)").setString(1, DEFAULT_TEMPLATE_PROPERTY)).setString(2, DEFAULT_PROJECT_TEMPLATE_PROPERTY)).setString(3, DEFAULT_VIEW_TEMPLATE_PROPERTY)).setString(4, DEFAULT_DEV_TEMPLATE_PROPERTY)).execute().commit();
    }

    private String updateKeeIfRequired(DataChange.Context context, @Nullable String kee) throws SQLException {
        if (kee == null || kee.length() <= 40) {
            return kee;
        }
        String newKee = this.uuidFactory.create();
        ((Upsert)((Upsert)context.prepareUpsert("update permission_templates set kee=? where kee=?").setString(1, newKee)).setString(2, kee)).execute();
        return newKee;
    }

    private static void ensureOnlyDefaultOrganizationExists(DataChange.Context context, String defaultOrganizationUuid) throws SQLException {
        Integer otherOrganizationCount = ((Select)context.prepareSelect("select count(*) from organizations where uuid <> ?").setString(1, defaultOrganizationUuid)).get(row -> row.getInt(1));
        Preconditions.checkState((otherOrganizationCount == 0 ? 1 : 0) != 0, (String)"Can not migrate DB if more than one organization exists. Remove all organizations but the default one which uuid is '%s'", (Object[])new Object[]{defaultOrganizationUuid});
    }

    private static Map<String, String> retrieveDefaultTemplateProperties(DataChange.Context context) throws SQLException {
        HashMap<String, String> templates = new HashMap<String, String>(3);
        ((Select)((Select)((Select)context.prepareSelect("select prop_key,is_empty,text_value from properties where prop_key in (?,?,?)").setString(1, DEFAULT_TEMPLATE_PROPERTY)).setString(2, DEFAULT_PROJECT_TEMPLATE_PROPERTY)).setString(3, DEFAULT_VIEW_TEMPLATE_PROPERTY)).scroll(row -> {
            String key = row.getString(1);
            boolean isEmpty = row.getBoolean(2);
            String textValue = row.getString(3);
            if (!isEmpty) {
                templates.put(key, textValue);
            }
        });
        return templates;
    }
}

