/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v64;

import java.sql.SQLException;
import org.sonar.api.utils.System2;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class PopulateColumnDefaultGroupIdOfOrganizations
extends DataChange {
    private final System2 system2;

    public PopulateColumnDefaultGroupIdOfOrganizations(Database db, System2 system2) {
        super(db);
        this.system2 = system2;
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        this.populateDefaultGroupId(context, PopulateColumnDefaultGroupIdOfOrganizations.isOrganizationEnabled(context) ? "Members" : "sonar-users");
    }

    private void populateDefaultGroupId(DataChange.Context context, String groupName) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate().rowPluralName("organizations");
        massUpdate.select("SELECT o.uuid, g.id FROM organizations o INNER JOIN groups g ON g.organization_uuid=o.uuid AND g.name=? WHERE o.default_group_id IS NULL").setString(1, groupName);
        massUpdate.update("UPDATE organizations SET default_group_id=?,updated_at=? WHERE uuid=?");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            update.setLong(1, row.getLong(2));
            update.setLong(2, this.system2.now());
            update.setString(3, row.getString(1));
            return true;
        });
    }

    private static boolean isOrganizationEnabled(DataChange.Context context) throws SQLException {
        Boolean result = ((Select)context.prepareSelect("SELECT text_value FROM internal_properties WHERE kee=?").setString(1, "organization.enabled")).get(row -> "true".equals(row.getString(1)));
        return result != null ? result : false;
    }
}

