/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v64;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.Upsert;
import org.sonar.server.platform.db.migration.version.v63.DefaultOrganizationUuidProvider;

public class SupportPrivateProjectInDefaultPermissionTemplate
extends DataChange {
    private static final String PERMISSION_USER = "user";
    private static final String PERMISSION_CODEVIEWER = "codeviewer";
    private DefaultOrganizationUuidProvider defaultOrganizationUuidProvider;

    public SupportPrivateProjectInDefaultPermissionTemplate(Database db, DefaultOrganizationUuidProvider defaultOrganizationUuidProvider) {
        super(db);
        this.defaultOrganizationUuidProvider = defaultOrganizationUuidProvider;
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        String defaultOrganizationUuid = this.defaultOrganizationUuidProvider.get(context);
        ResolvedOrganizationProperties organizationProperties = SupportPrivateProjectInDefaultPermissionTemplate.readOrganizationProperties(context, defaultOrganizationUuid);
        int defaultGroupId = organizationProperties.defaultGroupId;
        for (Integer groupId : Arrays.asList(organizationProperties.getProjectId(), organizationProperties.getViewId())) {
            if (groupId == null) continue;
            SupportPrivateProjectInDefaultPermissionTemplate.insertGroupPermissionIfNotPresent(context, defaultGroupId, groupId, PERMISSION_USER);
            SupportPrivateProjectInDefaultPermissionTemplate.insertGroupPermissionIfNotPresent(context, defaultGroupId, groupId, PERMISSION_CODEVIEWER);
        }
    }

    private static void insertGroupPermissionIfNotPresent(DataChange.Context context, int groupId, int templateId, String permission) throws SQLException {
        if (!SupportPrivateProjectInDefaultPermissionTemplate.groupHasPermissionInTemplate(context, templateId, groupId, permission)) {
            SupportPrivateProjectInDefaultPermissionTemplate.insertGroupPermission(context, templateId, groupId, permission);
        }
    }

    private static boolean groupHasPermissionInTemplate(DataChange.Context context, int templateId, int groupId, String permission) throws SQLException {
        List<Integer> rows = ((Select)((Select)((Select)context.prepareSelect("select 1 from perm_templates_groups where template_id = ? and group_id=? and permission_reference=?").setInt(1, templateId)).setInt(2, groupId)).setString(3, permission)).list(row -> row.getInt(1));
        return !rows.isEmpty();
    }

    private static void insertGroupPermission(DataChange.Context context, int templateId, int groupId, String permission) throws SQLException {
        Date now = new Date();
        ((Upsert)((Upsert)((Upsert)((Upsert)((Upsert)context.prepareUpsert("insert into perm_templates_groups (group_id, template_id, permission_reference, created_at, updated_at) values (?,?,?,?,?)").setInt(1, groupId)).setInt(2, templateId)).setString(3, permission)).setDate(4, now)).setDate(5, now)).execute().commit();
    }

    private static ResolvedOrganizationProperties readOrganizationProperties(DataChange.Context context, String defaultOrganizationUuid) throws SQLException {
        Select select = (Select)context.prepareSelect("select default_group_id, default_perm_template_project, default_perm_template_view from organizations where uuid=?").setString(1, defaultOrganizationUuid);
        List<OrganizationProperties> rows = select.list(row -> new OrganizationProperties(row.getNullableInt(1), row.getNullableString(2), row.getNullableString(3)));
        Preconditions.checkState((!rows.isEmpty() ? 1 : 0) != 0, (String)"Default organization with uuid '%s' does not exist in table ORGANIZATIONS", (Object[])new Object[]{defaultOrganizationUuid});
        OrganizationProperties rawProperties = rows.iterator().next();
        Preconditions.checkState((rawProperties.defaultGroupId != null ? 1 : 0) != 0, (String)"No default group id is defined for default organization (uuid=%s)", (Object[])new Object[]{defaultOrganizationUuid});
        Preconditions.checkState((rawProperties.projectUuid != null || rawProperties.viewUuid == null ? 1 : 0) != 0, (String)"Inconsistent state for default organization (uuid=%s): no project default template is defined but view default template is", (Object[])new Object[]{defaultOrganizationUuid});
        Integer projectTemplateId = SupportPrivateProjectInDefaultPermissionTemplate.getPermTemplateId(context, rawProperties.projectUuid);
        Integer viewTemplateId = SupportPrivateProjectInDefaultPermissionTemplate.getViewTemplateIdOrClearReference(context, rawProperties.viewUuid, defaultOrganizationUuid);
        return new ResolvedOrganizationProperties(rawProperties.defaultGroupId, projectTemplateId, viewTemplateId);
    }

    @CheckForNull
    private static Integer getPermTemplateId(DataChange.Context context, @Nullable String permissionTemplateUuid) throws SQLException {
        if (permissionTemplateUuid == null) {
            return null;
        }
        List<Integer> ids = SupportPrivateProjectInDefaultPermissionTemplate.getTemplateIds(context, permissionTemplateUuid);
        Preconditions.checkState((!ids.isEmpty() ? 1 : 0) != 0, (String)"Permission template with uuid %s not found", (Object[])new Object[]{permissionTemplateUuid});
        Preconditions.checkState((ids.size() == 1 ? 1 : 0) != 0, (String)"Multiple permission templates found with uuid %s", (Object[])new Object[]{permissionTemplateUuid});
        return ids.iterator().next();
    }

    @CheckForNull
    private static Integer getViewTemplateIdOrClearReference(DataChange.Context context, @Nullable String permissionTemplateUuid, String defaultOrganizationUuid) throws SQLException {
        if (permissionTemplateUuid == null) {
            return null;
        }
        List<Integer> ids = SupportPrivateProjectInDefaultPermissionTemplate.getTemplateIds(context, permissionTemplateUuid);
        if (ids.isEmpty()) {
            SupportPrivateProjectInDefaultPermissionTemplate.clearViewTemplateReference(context, defaultOrganizationUuid);
            return null;
        }
        Preconditions.checkState((ids.size() == 1 ? 1 : 0) != 0, (String)"Multiple permission templates found with uuid %s", (Object[])new Object[]{permissionTemplateUuid});
        return ids.iterator().next();
    }

    private static void clearViewTemplateReference(DataChange.Context context, String defaultOrganizationUuid) throws SQLException {
        ((Upsert)context.prepareUpsert("update organizations set default_perm_template_view = null where uuid=?").setString(1, defaultOrganizationUuid)).execute().commit();
        Loggers.get(SupportPrivateProjectInDefaultPermissionTemplate.class).info("Permission template with uuid %s referenced as default permission template for view does not exist. Reference cleared.");
    }

    private static List<Integer> getTemplateIds(DataChange.Context context, @Nullable String permissionTemplateUuid) throws SQLException {
        return ((Select)context.prepareSelect("select id from permission_templates where kee=?").setString(1, permissionTemplateUuid)).list(row -> row.getInt(1));
    }

    private static final class ResolvedOrganizationProperties {
        private final int defaultGroupId;
        private final Integer projectId;
        private final Integer viewId;

        private ResolvedOrganizationProperties(int defaultGroupId, @Nullable Integer projectId, @Nullable Integer viewId) {
            this.defaultGroupId = defaultGroupId;
            this.projectId = projectId;
            this.viewId = viewId;
        }

        int getDefaultGroupId() {
            return this.defaultGroupId;
        }

        Integer getProjectId() {
            return this.projectId;
        }

        @CheckForNull
        Integer getViewId() {
            return this.viewId;
        }
    }

    private static final class OrganizationProperties {
        private final Integer defaultGroupId;
        private final String projectUuid;
        private final String viewUuid;

        private OrganizationProperties(@Nullable Integer defaultGroupId, @Nullable String projectUuid, @Nullable String viewUuid) {
            this.defaultGroupId = defaultGroupId;
            this.projectUuid = projectUuid;
            this.viewUuid = viewUuid;
        }
    }
}

