/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v65;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class UpdateOrgQProfilesToPointToBuiltInProfiles
extends DataChange {
    private static final String PROP_DEFAULT_ORGANIZATION_UUID = "organization.default";
    private static final String PROP_ORGANIZATION_ENABLED = "organization.enabled";

    public UpdateOrgQProfilesToPointToBuiltInProfiles(Database db) {
        super(db);
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        if (!UpdateOrgQProfilesToPointToBuiltInProfiles.isOrganizationEnabled(context)) {
            return;
        }
        String defaultOrganizationUuid = UpdateOrgQProfilesToPointToBuiltInProfiles.getDefaultOrganizationUuid(context);
        BuiltInRulesProfiles builtInRulesProfiles = UpdateOrgQProfilesToPointToBuiltInProfiles.retrieveBuiltInRulesProfiles(context);
        MassUpdate massUpdate = context.prepareMassUpdate().rowPluralName("org qprofiles");
        massUpdate.select("select oqp.uuid, rp.language, rp.name  from org_qprofiles oqp  inner join rules_profiles rp on rp.kee = oqp.rules_profile_uuid  where oqp.organization_uuid <> ?    and rp.is_built_in = ?    and oqp.user_updated_at is null").setString(1, defaultOrganizationUuid).setBoolean(2, false);
        massUpdate.update("update org_qprofiles set rules_profile_uuid = ? where uuid=?");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            String orgQProfileUuid = row.getString(1);
            String language = row.getString(2);
            String name = row.getString(3);
            if (!builtInRulesProfiles.contains(name, language)) {
                return false;
            }
            update.setString(1, builtInRulesProfiles.get(name, language));
            update.setString(2, orgQProfileUuid);
            return true;
        });
    }

    private static String getDefaultOrganizationUuid(DataChange.Context context) throws SQLException {
        String defaultOrganizationUuid = ((Select)context.prepareSelect("select text_value from internal_properties where kee=?").setString(1, PROP_DEFAULT_ORGANIZATION_UUID)).get(row -> row.getString(1));
        Preconditions.checkState((defaultOrganizationUuid != null ? 1 : 0) != 0, (String)"Missing internal property: '%s'", (Object[])new Object[]{PROP_DEFAULT_ORGANIZATION_UUID});
        return defaultOrganizationUuid;
    }

    private static boolean isOrganizationEnabled(DataChange.Context context) throws SQLException {
        String value = ((Select)context.prepareSelect("select text_value from internal_properties where kee=?").setString(1, PROP_ORGANIZATION_ENABLED)).get(row -> row.getNullableString(1));
        return "true".equals(value);
    }

    private static BuiltInRulesProfiles retrieveBuiltInRulesProfiles(DataChange.Context context) throws SQLException {
        BuiltInRulesProfiles result = new BuiltInRulesProfiles();
        ((Select)context.prepareSelect("select name, language, kee from rules_profiles  where is_built_in = ? ").setBoolean(1, true)).list(row -> result.put(row.getString(1), row.getString(2), row.getString(3)));
        return result;
    }

    private static class BuiltInRulesProfiles {
        private Table<String, String, String> table = HashBasedTable.create();

        private BuiltInRulesProfiles() {
        }

        private String put(String name, String language, String rulesProfileUuid) {
            return (String)this.table.put((Object)name, (Object)language, (Object)rulesProfileUuid);
        }

        private boolean contains(String name, String language) {
            return this.table.contains((Object)name, (Object)language);
        }

        private String get(String name, String language) {
            return (String)this.table.get((Object)name, (Object)language);
        }
    }
}

