/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v70;

import java.sql.SQLException;
import java.util.Date;
import org.sonar.api.utils.System2;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.Upsert;

public class CreateBuiltInQualityGate
extends DataChange {
    private static final String SONAR_WAY_QUALITY_GATE = "Sonar way";
    private final System2 system2;
    private final UuidFactory uuidFactory;

    public CreateBuiltInQualityGate(Database db, System2 system2, UuidFactory uuidFactory) {
        super(db);
        this.system2 = system2;
        this.uuidFactory = uuidFactory;
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        Long nbOfBuiltInQualityGates = ((Select)context.prepareSelect("select count(uuid) from quality_gates where is_built_in = ?").setBoolean(1, true)).get(row -> row.getLong(1));
        if (nbOfBuiltInQualityGates == 0L) {
            Date now = new Date(this.system2.now());
            ((Upsert)((Upsert)((Upsert)((Upsert)context.prepareUpsert("insert into quality_gates (uuid, name, is_built_in, created_at) values (?,?,?,?)").setString(1, this.uuidFactory.create())).setString(2, SONAR_WAY_QUALITY_GATE)).setBoolean(3, true)).setDate(4, now)).execute().commit();
        }
    }
}

