/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v70;

import java.sql.Connection;
import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.db.DatabaseUtils;
import org.sonar.server.platform.db.migration.def.VarcharColumnDef;
import org.sonar.server.platform.db.migration.sql.CreateIndexBuilder;
import org.sonar.server.platform.db.migration.sql.CreateTableBuilder;
import org.sonar.server.platform.db.migration.step.DdlChange;

public class CreateOrgQualityGatesTable
extends DdlChange {
    private static final String ORG_QUALITY_GATES = "org_quality_gates";
    private static final VarcharColumnDef ORGANIZATION_UUID_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("organization_uuid").setIsNullable(false).setLimit(40).build();
    private static final VarcharColumnDef QUALITY_GATE_UUID_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("quality_gate_uuid").setIsNullable(false).setLimit(40).build();
    private Database db;

    public CreateOrgQualityGatesTable(Database db) {
        super(db);
        this.db = db;
    }

    @Override
    public void execute(DdlChange.Context context) throws SQLException {
        if (!this.tableExists()) {
            context.execute(new CreateTableBuilder(this.getDialect(), ORG_QUALITY_GATES).addPkColumn(VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("uuid").setIsNullable(false).setLimit(40).build(), new CreateTableBuilder.ColumnFlag[0]).addColumn(ORGANIZATION_UUID_COLUMN).addColumn(QUALITY_GATE_UUID_COLUMN).build());
            context.execute(new CreateIndexBuilder(this.getDialect()).addColumn(ORGANIZATION_UUID_COLUMN).addColumn(QUALITY_GATE_UUID_COLUMN).setUnique(true).setTable(ORG_QUALITY_GATES).setName("uniq_org_quality_gates").build());
        }
    }

    private boolean tableExists() throws SQLException {
        try (Connection connection = this.db.getDataSource().getConnection();){
            boolean bl = DatabaseUtils.tableExists((String)ORG_QUALITY_GATES, (Connection)connection);
            return bl;
        }
    }
}

