/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v70;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import javax.annotation.CheckForNull;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class ReadGlobalSonarQualityGateSettingToDefaultOrg
extends DataChange {
    private static final Logger LOGGER = Loggers.get(ReadGlobalSonarQualityGateSettingToDefaultOrg.class);
    private final System2 system2;

    public ReadGlobalSonarQualityGateSettingToDefaultOrg(Database db, System2 system2) {
        super(db);
        this.system2 = system2;
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        String defaultOrgUuid = ReadGlobalSonarQualityGateSettingToDefaultOrg.getDefaultOrgUuid(context);
        String defaultQualityGate = ReadGlobalSonarQualityGateSettingToDefaultOrg.getDefaultQualityGate(context);
        if (defaultQualityGate == null) {
            LOGGER.info("No default quality gate set");
            return;
        }
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select uuid from quality_gates where id=?").setLong(1, Long.parseLong(defaultQualityGate));
        massUpdate.update("update organizations set default_quality_gate_uuid = ?, updated_at = ? where uuid=?");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            update.setString(1, row.getString(1));
            update.setLong(2, this.system2.now());
            update.setString(3, defaultOrgUuid);
            return true;
        });
    }

    private static String getDefaultOrgUuid(DataChange.Context context) throws SQLException {
        String defaultOrgUuid = context.prepareSelect("select text_value from internal_properties where kee = 'organization.default'").get(row -> row.getString(1));
        Preconditions.checkState((defaultOrgUuid != null ? 1 : 0) != 0, (Object)"Default organization uuid is missing");
        return defaultOrgUuid;
    }

    @CheckForNull
    private static String getDefaultQualityGate(DataChange.Context context) throws SQLException {
        return ((Select)context.prepareSelect("select text_value from properties where prop_key=? and resource_id is null").setString(1, "sonar.qualitygate")).get(row -> row.getNullableString(1));
    }
}

