/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v73;

import java.sql.SQLException;
import org.sonar.api.utils.System2;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.SupportsBlueGreen;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

@SupportsBlueGreen
public class PopulateMainApplicationBranches
extends DataChange {
    private static final String MAIN_BRANCH_NAME = "master";
    private final System2 system2;

    public PopulateMainApplicationBranches(Database db, System2 system2) {
        super(db);
        this.system2 = system2;
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        long now = this.system2.now();
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("SELECT uuid FROM projects p WHERE p.scope='PRJ' AND p.qualifier='APP' AND p.main_branch_project_uuid IS NULL AND NOT EXISTS (SELECT uuid FROM project_branches b WHERE b.uuid = p.uuid)");
        massUpdate.update("INSERT INTO project_branches (uuid, project_uuid, kee, branch_type, key_type, merge_branch_uuid, created_at, updated_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        massUpdate.rowPluralName("applications");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            String uuid = row.getString(1);
            update.setString(1, uuid);
            update.setString(2, uuid);
            update.setString(3, MAIN_BRANCH_NAME);
            update.setString(4, "LONG");
            update.setString(5, "BRANCH");
            update.setString(6, null);
            update.setLong(7, now);
            update.setLong(8, now);
            return true;
        });
    }
}

