/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce;

import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.sonar.ce.CeDistributedInformation;
import org.sonar.ce.taskprocessor.CeWorker;
import org.sonar.ce.taskprocessor.CeWorkerFactory;
import org.sonar.core.util.stream.MoreCollectors;

public class StandaloneCeDistributedInformation
implements CeDistributedInformation {
    private final CeWorkerFactory ceCeWorkerFactory;
    private Set<String> workerUUIDs;
    private Lock cleanJobLock = new NonConcurrentLock();

    public StandaloneCeDistributedInformation(CeWorkerFactory ceCeWorkerFactory) {
        this.ceCeWorkerFactory = ceCeWorkerFactory;
    }

    @Override
    public Set<String> getWorkerUUIDs() {
        Preconditions.checkState((this.workerUUIDs != null ? 1 : 0) != 0, (Object)"Invalid call, broadcastWorkerUUIDs() must be called first.");
        return this.workerUUIDs;
    }

    @Override
    public void broadcastWorkerUUIDs() {
        Set<CeWorker> workers = this.ceCeWorkerFactory.getWorkers();
        this.workerUUIDs = (Set)workers.stream().map(CeWorker::getUUID).collect(MoreCollectors.toSet((int)workers.size()));
    }

    @Override
    public Lock acquireCleanJobLock() {
        return this.cleanJobLock;
    }

    private static class NonConcurrentLock
    implements Lock {
        private NonConcurrentLock() {
        }

        @Override
        public void lock() {
        }

        @Override
        public void lockInterruptibly() {
        }

        @Override
        public boolean tryLock() {
            return true;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) {
            return true;
        }

        @Override
        public void unlock() {
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException("newCondition not supported");
        }
    }
}

