/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process.cluster.health;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.sonar.process.cluster.health.NodeDetails;

public class NodeHealth
implements Externalizable {
    private Status status;
    private Set<String> causes;
    private NodeDetails details;

    public NodeHealth() {
    }

    private NodeHealth(Builder builder) {
        this.status = builder.status;
        this.causes = ImmutableSet.copyOf((Collection)builder.causes);
        this.details = builder.details;
    }

    public static Builder newNodeHealthBuilder() {
        return new Builder();
    }

    public Status getStatus() {
        return this.status;
    }

    public Set<String> getCauses() {
        return this.causes;
    }

    public NodeDetails getDetails() {
        return this.details;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.status.ordinal());
        out.writeInt(this.causes.size());
        for (String cause : this.causes) {
            out.writeUTF(cause);
        }
        out.writeObject(this.details);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.status = Status.values()[in.readInt()];
        int size = in.readInt();
        if (size > 0) {
            HashSet<String> readCauses = new HashSet<String>(size);
            for (int i = 0; i < size; ++i) {
                readCauses.add(in.readUTF());
            }
            this.causes = ImmutableSet.copyOf(readCauses);
        } else {
            this.causes = ImmutableSet.of();
        }
        this.details = (NodeDetails)in.readObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeHealth that = (NodeHealth)o;
        return this.status == that.status && this.causes.equals(that.causes) && this.details.equals(that.details);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.causes, this.details});
    }

    public String toString() {
        return "NodeHealth{status=" + (Object)((Object)this.status) + ", causes=" + this.causes + ", details=" + this.details + '}';
    }

    public static enum Status {
        GREEN,
        YELLOW,
        RED;

    }

    public static class Builder {
        private static final String STATUS_CANT_BE_NULL = "status can't be null";
        private static final String DETAILS_CANT_BE_NULL = "details can't be null";
        private Status status;
        private Set<String> causes = new HashSet<String>(0);
        private NodeDetails details;

        private Builder() {
        }

        public Builder setStatus(Status status) {
            this.status = Objects.requireNonNull(status, STATUS_CANT_BE_NULL);
            return this;
        }

        public Builder clearCauses() {
            this.causes.clear();
            return this;
        }

        public Builder addCause(String cause) {
            Objects.requireNonNull(cause, "cause can't be null");
            String trimmed = cause.trim();
            Preconditions.checkArgument((!trimmed.isEmpty() ? 1 : 0) != 0, (Object)"cause can't be empty");
            this.causes.add(cause);
            return this;
        }

        public Builder setDetails(NodeDetails details) {
            Objects.requireNonNull(details, DETAILS_CANT_BE_NULL);
            this.details = details;
            return this;
        }

        public NodeHealth build() {
            Objects.requireNonNull(this.status, STATUS_CANT_BE_NULL);
            Objects.requireNonNull(this.details, DETAILS_CANT_BE_NULL);
            return new NodeHealth(this);
        }
    }
}

