/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.io.ByteArrayOutputStream;
import org.jruby.MetaClass;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.compiler.Compilable;
import org.jruby.internal.runtime.AbstractIRMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.persistence.IRDumper;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class MixedModeIRMethod
extends AbstractIRMethod
implements Compilable<DynamicMethod> {
    private static final Logger LOG = LoggerFactory.getLogger(MixedModeIRMethod.class);
    private boolean displayedCFG = false;
    private volatile int callCount = 0;
    private volatile DynamicMethod actualMethod;

    public MixedModeIRMethod(IRScope method2, Visibility visibility, RubyModule implementationClass) {
        super(method2, visibility, implementationClass);
        this.getStaticScope().determineModule();
        if (!implementationClass.getRuntime().getInstanceConfig().getCompileMode().shouldJIT() || Options.JIT_THRESHOLD.load() < 0) {
            this.callCount = -1;
        }
    }

    public DynamicMethod getActualMethod() {
        return this.actualMethod;
    }

    protected void post(InterpreterContext ic, ThreadContext context) {
        context.popFrame();
        if (ic.popDynScope()) {
            context.popScope();
        }
    }

    protected void pre(InterpreterContext ic, ThreadContext context, IRubyObject self2, String name2, Block block, RubyModule implClass) {
        context.preMethodFrameOnly(implClass, name2, self2, block);
        if (ic.pushNewDynScope()) {
            context.pushScope(DynamicScope.newDynamicScope(ic.getStaticScope()));
        }
    }

    @Override
    public InterpreterContext ensureInstrsReady() {
        if (this.method instanceof IRMethod) {
            return ((IRMethod)this.method).lazilyAcquireInterpreterContext();
        }
        InterpreterContext ic = this.method.getInterpreterContext();
        if (IRRuntimeHelpers.shouldPrintIR(this.implementationClass.getRuntime())) {
            ByteArrayOutputStream baos = IRDumper.printIR(this.method, false);
            LOG.info("Printing simple IR for " + this.method.getId() + ":\n" + new String(baos.toByteArray()), new Object[0]);
        }
        return ic;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        DynamicMethod jittedMethod;
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        if (this.callCount >= 0) {
            this.tryJit(context);
        }
        if ((jittedMethod = this.actualMethod) != null) {
            return jittedMethod.call(context, self2, this.getImplementationClass().getMethodLocation(), name2, args2, block);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), this.getImplementationClass().getMethodLocation(), self2, name2, args2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject INTERPRET_METHOD(ThreadContext context, InterpreterContext ic, RubyModule implClass, IRubyObject self2, String name2, IRubyObject[] args2, Block block) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), context.getLine());
            if (ic.hasExplicitCallProtocol()) {
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, args2, block);
                return iRubyObject;
            }
            try {
                this.pre(ic, context, self2, name2, block, implClass);
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, args2, block);
                this.post(ic, context);
                return iRubyObject;
            }
            catch (Throwable throwable) {
                this.post(ic, context);
                throw throwable;
            }
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
        DynamicMethod jittedMethod;
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        if (this.callCount >= 0) {
            this.tryJit(context);
        }
        if ((jittedMethod = this.actualMethod) != null) {
            return jittedMethod.call(context, self2, this.getImplementationClass().getMethodLocation(), name2, block);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), this.getImplementationClass().getMethodLocation(), self2, name2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject INTERPRET_METHOD(ThreadContext context, InterpreterContext ic, RubyModule implClass, IRubyObject self2, String name2, Block block) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), context.getLine());
            if (ic.hasExplicitCallProtocol()) {
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, block);
                return iRubyObject;
            }
            try {
                this.pre(ic, context, self2, name2, block, implClass);
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, block);
                this.post(ic, context);
                return iRubyObject;
            }
            catch (Throwable throwable) {
                this.post(ic, context);
                throw throwable;
            }
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        DynamicMethod jittedMethod;
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        if (this.callCount >= 0) {
            this.tryJit(context);
        }
        if ((jittedMethod = this.actualMethod) != null) {
            return jittedMethod.call(context, self2, this.getImplementationClass().getMethodLocation(), name2, arg0, block);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), this.getImplementationClass().getMethodLocation(), self2, name2, arg0, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject INTERPRET_METHOD(ThreadContext context, InterpreterContext ic, RubyModule implClass, IRubyObject self2, String name2, IRubyObject arg1, Block block) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), context.getLine());
            if (ic.hasExplicitCallProtocol()) {
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, arg1, block);
                return iRubyObject;
            }
            try {
                this.pre(ic, context, self2, name2, block, implClass);
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, arg1, block);
                this.post(ic, context);
                return iRubyObject;
            }
            catch (Throwable throwable) {
                this.post(ic, context);
                throw throwable;
            }
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        DynamicMethod jittedMethod;
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        if (this.callCount >= 0) {
            this.tryJit(context);
        }
        if ((jittedMethod = this.actualMethod) != null) {
            return jittedMethod.call(context, self2, this.getImplementationClass().getMethodLocation(), name2, arg0, arg1, block);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), this.getImplementationClass().getMethodLocation(), self2, name2, arg0, arg1, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject INTERPRET_METHOD(ThreadContext context, InterpreterContext ic, RubyModule implClass, IRubyObject self2, String name2, IRubyObject arg1, IRubyObject arg2, Block block) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), context.getLine());
            if (ic.hasExplicitCallProtocol()) {
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, arg1, arg2, block);
                return iRubyObject;
            }
            try {
                this.pre(ic, context, self2, name2, block, implClass);
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, arg1, arg2, block);
                this.post(ic, context);
                return iRubyObject;
            }
            catch (Throwable throwable) {
                this.post(ic, context);
                throw throwable;
            }
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        DynamicMethod jittedMethod;
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        if (this.callCount >= 0) {
            this.tryJit(context);
        }
        if ((jittedMethod = this.actualMethod) != null) {
            return jittedMethod.call(context, self2, this.getImplementationClass().getMethodLocation(), name2, arg0, arg1, arg2, block);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), this.getImplementationClass().getMethodLocation(), self2, name2, arg0, arg1, arg2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject INTERPRET_METHOD(ThreadContext context, InterpreterContext ic, RubyModule implClass, IRubyObject self2, String name2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), context.getLine());
            if (ic.hasExplicitCallProtocol()) {
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, arg1, arg2, arg3, block);
                return iRubyObject;
            }
            try {
                this.pre(ic, context, self2, name2, block, implClass);
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, arg1, arg2, arg3, block);
                this.post(ic, context);
                return iRubyObject;
            }
            catch (Throwable throwable) {
                this.post(ic, context);
                throw throwable;
            }
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    private void doDebug() {
        this.ensureInstrsReady();
        LOG.info("Executing '" + this.method.getId() + "'", new Object[0]);
        if (!this.displayedCFG) {
            LOG.info(this.method.debugOutput(), new Object[0]);
            this.displayedCFG = true;
        }
    }

    @Override
    public void completeBuild(DynamicMethod newMethod) {
        this.setCallCount(-1);
        newMethod.serialNumber = this.serialNumber;
        this.actualMethod = newMethod;
        this.getImplementationClass().invalidateCacheDescendants();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryJit(ThreadContext context) {
        if (context.runtime.isBooting() && !Options.JIT_KERNEL.load().booleanValue()) {
            return;
        }
        MixedModeIRMethod mixedModeIRMethod = this;
        synchronized (mixedModeIRMethod) {
            if (this.callCount >= 0 && this.callCount++ >= Options.JIT_THRESHOLD.load()) {
                context.runtime.getJITCompiler().buildThresholdReached(context, this);
            }
        }
    }

    @Override
    public String getClassName(ThreadContext context) {
        MetaClass metaClass;
        RubyClass realClass;
        String className = this.implementationClass.isSingleton() ? ((realClass = (metaClass = (MetaClass)this.implementationClass).getRealClass()) == context.runtime.getClassClass() ? ((RubyClass)metaClass.getAttached()).getName() : realClass.getName()) : this.implementationClass.getName();
        return className;
    }

    @Override
    public DynamicMethod dup() {
        MixedModeIRMethod x = (MixedModeIRMethod)super.dup();
        x.callCount = this.callCount;
        x.actualMethod = this.actualMethod;
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCallCount(int callCount) {
        MixedModeIRMethod mixedModeIRMethod = this;
        synchronized (mixedModeIRMethod) {
            this.callCount = callCount;
        }
    }
}

