/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.text.MessageFormat;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.slang.api.MatchCaseTree;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SlangCheck;

@Rule(key="S1151")
public class MatchCaseTooBigCheck
implements SlangCheck {
    private static final int DEFAULT_MAX = 15;
    private static final String MESSAGE = "Reduce this case clause number of lines from {0} to at most {1}, for example by extracting code into methods.";
    @RuleProperty(key="max", description="Maximum number of lines", defaultValue="15")
    public int max = 15;

    @Override
    public void initialize(InitContext init) {
        init.register(MatchCaseTree.class, (ctx, matchCaseTree) -> {
            int linesOfCode = matchCaseTree.metaData().linesOfCode().size();
            if (linesOfCode > this.max) {
                ctx.reportIssue(matchCaseTree.rangeToHighlight(), MessageFormat.format(MESSAGE, linesOfCode, this.max));
            }
        });
    }
}

