/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.visitors;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.sonarsource.slang.api.AssignmentExpressionTree;
import org.sonarsource.slang.api.BinaryExpressionTree;
import org.sonarsource.slang.api.IdentifierTree;
import org.sonarsource.slang.api.LiteralTree;
import org.sonarsource.slang.api.ModifierTree;
import org.sonarsource.slang.api.NativeTree;
import org.sonarsource.slang.api.TextPointer;
import org.sonarsource.slang.api.TextRange;
import org.sonarsource.slang.api.Token;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.visitors.TreeContext;
import org.sonarsource.slang.visitors.TreeVisitor;

public class TreePrinter {
    private TreePrinter() {
    }

    public static String tree2string(List<Tree> trees) {
        return trees.stream().map(TreePrinter::tree2string).collect(Collectors.joining("\n"));
    }

    public static String tree2string(Tree tree) {
        StringBuilder sb = new StringBuilder();
        TreeVisitor<TreeContext> visitor = new TreeVisitor<TreeContext>();
        visitor.register(Tree.class, (ctx, t) -> {
            IntStream.range(0, ctx.ancestors().size()).forEach(i2 -> sb.append("  "));
            sb.append(t.getClass().getSimpleName());
            if (t instanceof BinaryExpressionTree) {
                sb.append(" ").append(((BinaryExpressionTree)t).operator().name());
            } else if (t instanceof AssignmentExpressionTree) {
                sb.append(" ").append(((AssignmentExpressionTree)t).operator().name());
            } else if (t instanceof LiteralTree) {
                sb.append(" ").append(((LiteralTree)t).value());
            } else if (t instanceof IdentifierTree) {
                sb.append(" ").append(((IdentifierTree)t).name());
            } else if (t instanceof NativeTree) {
                sb.append(" ").append(((NativeTree)t).nativeKind());
            } else if (t instanceof ModifierTree) {
                sb.append(" ").append((Object)((ModifierTree)t).kind());
            }
            sb.append("\n");
        });
        visitor.scan(new TreeContext(), tree);
        return sb.toString();
    }

    public static String table(Tree tree) {
        Table table = new Table("AST node class", "first\u2026last tokens", "line:col");
        TreePrinter.addAstNode(table, tree, 0);
        return table.toString();
    }

    private static void addAstNode(Table table, Tree node, int indentSize) {
        String indent = TreePrinter.repeat(' ', indentSize);
        boolean hasChildren = !node.children().isEmpty();
        table.add(indent + TreePrinter.kind(node) + (hasChildren ? " {" : ""), TreePrinter.firstToLastTokens(node.metaData().tokens()), TreePrinter.toLineColumn(node));
        for (Tree child : node.children()) {
            TreePrinter.addAstNode(table, child, indentSize + 2);
        }
        if (hasChildren) {
            table.add(indent + "}", "", "");
        }
    }

    private static String firstToLastTokens(List<Token> tokens) {
        if (tokens.isEmpty()) {
            return "";
        }
        String firstToken = TreePrinter.escapeWhiteSpace(tokens.get(0).text());
        String lastToken = TreePrinter.escapeWhiteSpace(tokens.get(tokens.size() - 1).text());
        if (tokens.size() == 1) {
            return TreePrinter.truncate(firstToken, 23);
        }
        return TreePrinter.truncateFromLeft(firstToken, 10) + " \u2026 " + TreePrinter.truncateFromRight(lastToken, 10);
    }

    private static String truncate(String text, int maxSize) {
        if (text.length() > maxSize) {
            return TreePrinter.truncateFromLeft(text, maxSize / 2) + "\u2026" + TreePrinter.truncateFromRight(text, maxSize - maxSize / 2 - 1);
        }
        return text;
    }

    private static String truncateFromLeft(String text, int maxSize) {
        return text.length() > maxSize ? text.substring(0, maxSize) : text;
    }

    private static String truncateFromRight(String text, int maxSize) {
        return text.length() > maxSize ? text.substring(text.length() - maxSize) : text;
    }

    private static String escapeWhiteSpace(String text) {
        return text.replace("\\", "\\\\").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    public static String kind(Tree node) {
        if (node instanceof NativeTree) {
            return "?" + ((NativeTree)node).nativeKind().toString() + "?";
        }
        return node.getClass().getSimpleName().replaceFirst("Impl$", "");
    }

    private static String toLineColumn(Tree node) {
        return TreePrinter.toLineColumn(node.textRange());
    }

    private static String toLineColumn(TextRange range) {
        return TreePrinter.toLineColumn(range.start()) + " \u2026 " + TreePrinter.toLineColumn(range.end());
    }

    private static String toLineColumn(TextPointer pointer2) {
        return pointer2.line() + ":" + (pointer2.lineOffset() + 1);
    }

    private static String repeat(char filler, int count2) {
        return new String(new char[count2]).replace('\u0000', filler);
    }

    public static class Table {
        private final int colCount;
        private final String[] columnNames;
        private final int[] colWidths;
        private final List<String[]> rows;

        public Table(String ... columnNames) {
            this.colCount = columnNames.length;
            this.colWidths = new int[this.colCount];
            this.columnNames = columnNames;
            for (int col = 0; col < this.colCount; ++col) {
                this.colWidths[col] = this.columnNames[col].length();
            }
            this.rows = new ArrayList<String[]>();
        }

        public void add(Object ... columnValues) {
            if (columnValues.length != this.colCount) {
                throw new IllegalArgumentException("columnValues.length (" + this.columnNames.length + ") must be " + this.colCount);
            }
            String[] row = new String[this.colCount];
            for (int col = 0; col < this.colCount; ++col) {
                row[col] = String.valueOf(columnValues[col]);
                if (this.colWidths[col] >= row[col].length()) continue;
                this.colWidths[col] = row[col].length();
            }
            this.rows.add(row);
        }

        public String toString() {
            int col;
            StringBuilder out = new StringBuilder();
            for (col = 0; col < this.colCount; ++col) {
                this.appendCol(out, this.columnNames[col], col, ' ');
            }
            out.append('\n');
            for (col = 0; col < this.colCount; ++col) {
                this.appendCol(out, "", col, '-');
            }
            for (String[] row : this.rows) {
                out.append('\n');
                for (int col2 = 0; col2 < this.colCount; ++col2) {
                    this.appendCol(out, row[col2], col2, ' ');
                }
            }
            return out.toString();
        }

        private void appendCol(StringBuilder out, String value2, int col, char filler) {
            int start2 = out.length();
            out.append(value2);
            Table.fill(out, filler, start2 + this.colWidths[col]);
            if (col + 1 < this.colCount) {
                out.append(filler).append('|').append(filler);
            }
        }

        private static void fill(StringBuilder out, char filler, int endExcluded) {
            while (out.length() < endExcluded) {
                out.append(filler);
            }
        }
    }
}

