/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.pylint;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.analyzer.commons.xml.SafetyFactory;

public class PylintRuleParser {
    private static final Logger LOG = Loggers.get(PylintRuleParser.class);
    private Set<String> definedRulesId = new HashSet<String>();
    private StringBuilder currentKey = new StringBuilder();

    public PylintRuleParser(String rulesPath) {
        try (InputStream inputStream = this.getClass().getResourceAsStream(rulesPath);){
            XMLEventReader reader = SafetyFactory.createXMLInputFactory().createXMLEventReader(inputStream);
            while (reader.hasNext()) {
                this.onXmlEvent(reader.nextEvent());
            }
        }
        catch (IOException | IllegalArgumentException | XMLStreamException e) {
            LOG.warn("Unable to parse the Pylint rules definition XML file");
        }
        if (this.definedRulesId.isEmpty()) {
            LOG.warn("No rule key found for Pylint");
        }
    }

    private void onXmlEvent(XMLEvent event) {
        if (event.isStartElement()) {
            StartElement element = event.asStartElement();
            String elementName = element.getName().getLocalPart();
            if ("key".equals(elementName)) {
                this.currentKey = new StringBuilder();
            }
        } else if (event.isCharacters()) {
            this.currentKey.append(event.asCharacters().getData());
        } else if (event.isEndElement() && "key".equals(event.asEndElement().getName().getLocalPart())) {
            this.definedRulesId.add(this.currentKey.toString());
        }
    }

    public boolean hasRuleDefinition(String ruleId) {
        return this.definedRulesId.contains(ruleId);
    }
}

