/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import java.text.MessageFormat;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonCheck;
import org.sonar.python.metrics.ComplexityVisitor;

@Rule(key="FileComplexity")
public class FileComplexityCheck
extends PythonCheck {
    private static final int DEFAULT_MAXIMUM_FILE_COMPLEXITY_THRESHOLD = 200;
    @RuleProperty(key="maximumFileComplexityThreshold", defaultValue="200")
    int maximumFileComplexityThreshold = 200;

    @Override
    public void leaveFile(AstNode astNode) {
        int complexity = ComplexityVisitor.complexity(astNode);
        if (complexity > this.maximumFileComplexityThreshold) {
            String message = MessageFormat.format("File has a complexity of {0,number,integer} which is greater than {1,number,integer} authorized.", complexity, this.maximumFileComplexityThreshold);
            this.addFileIssue(message).withCost(complexity - this.maximumFileComplexityThreshold);
        }
    }
}

