/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.auth.saml;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.sonar.api.PropertyType;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.server.ServerSide;

@ServerSide
public class SamlSettings {
    private static final String ENABLED = "sonar.auth.saml.enabled";
    private static final String PROVIDER_ID = "sonar.auth.saml.providerId";
    private static final String PROVIDER_NAME = "sonar.auth.saml.providerName";
    private static final String APPLICATION_ID = "sonar.auth.saml.applicationId";
    private static final String LOGIN_URL = "sonar.auth.saml.loginUrl";
    private static final String CERTIFICATE = "sonar.auth.saml.certificate.secured";
    private static final String USER_LOGIN_ATTRIBUTE = "sonar.auth.saml.user.login";
    private static final String USER_NAME_ATTRIBUTE = "sonar.auth.saml.user.name";
    private static final String USER_EMAIL_ATTRIBUTE = "sonar.auth.saml.user.email";
    private static final String GROUP_NAME_ATTRIBUTE = "sonar.auth.saml.group.name";
    private static final String CATEGORY = "saml";
    private static final String SUBCATEGORY = "authentication";
    private final Configuration configuration;

    public SamlSettings(Configuration configuration) {
        this.configuration = configuration;
    }

    String getProviderId() {
        return (String)this.configuration.get(PROVIDER_ID).orElseThrow(() -> new IllegalArgumentException("Provider ID is missing"));
    }

    String getProviderName() {
        return (String)this.configuration.get(PROVIDER_NAME).orElseThrow(() -> new IllegalArgumentException("Provider Name is missing"));
    }

    String getApplicationId() {
        return (String)this.configuration.get(APPLICATION_ID).orElseThrow(() -> new IllegalArgumentException("Application ID is missing"));
    }

    String getLoginUrl() {
        return (String)this.configuration.get(LOGIN_URL).orElseThrow(() -> new IllegalArgumentException("Login URL is missing"));
    }

    String getCertificate() {
        return (String)this.configuration.get(CERTIFICATE).orElseThrow(() -> new IllegalArgumentException("Certificate is missing"));
    }

    String getUserLogin() {
        return (String)this.configuration.get(USER_LOGIN_ATTRIBUTE).orElseThrow(() -> new IllegalArgumentException("User login attribute is missing"));
    }

    String getUserName() {
        return (String)this.configuration.get(USER_NAME_ATTRIBUTE).orElseThrow(() -> new IllegalArgumentException("User name attribute is missing"));
    }

    Optional<String> getUserEmail() {
        return this.configuration.get(USER_EMAIL_ATTRIBUTE);
    }

    Optional<String> getGroupName() {
        return this.configuration.get(GROUP_NAME_ATTRIBUTE);
    }

    boolean isEnabled() {
        return this.configuration.getBoolean(ENABLED).orElse(false) != false && this.configuration.get(PROVIDER_ID).isPresent() && this.configuration.get(APPLICATION_ID).isPresent() && this.configuration.get(LOGIN_URL).isPresent() && this.configuration.get(CERTIFICATE).isPresent() && this.configuration.get(USER_LOGIN_ATTRIBUTE).isPresent() && this.configuration.get(USER_NAME_ATTRIBUTE).isPresent();
    }

    static List<PropertyDefinition> definitions() {
        return Arrays.asList(PropertyDefinition.builder((String)ENABLED).name("Enabled").description("Enable SAML users to login. Value is ignored if provider ID, login url, certificate, login, name attributes are not defined.").category(CATEGORY).subCategory(SUBCATEGORY).type(PropertyType.BOOLEAN).defaultValue(String.valueOf(false)).index(1).build(), PropertyDefinition.builder((String)APPLICATION_ID).name("Application ID").description("Identifier of the application.").defaultValue("sonarqube").category(CATEGORY).subCategory(SUBCATEGORY).index(2).build(), PropertyDefinition.builder((String)PROVIDER_NAME).name("Provider Name").description("Name displayed for the provider in the login page.").defaultValue("SAML").category(CATEGORY).subCategory(SUBCATEGORY).index(3).build(), PropertyDefinition.builder((String)PROVIDER_ID).name("Provider ID").description("Identifier of the identity provider, the entity that provides SAML authentication.").category(CATEGORY).subCategory(SUBCATEGORY).index(4).build(), PropertyDefinition.builder((String)LOGIN_URL).name("SAML login url").description("SAML login URL for the identity provider.").category(CATEGORY).subCategory(SUBCATEGORY).index(5).build(), PropertyDefinition.builder((String)CERTIFICATE).name("Provider certificate").description("X.509 certificate for the identity provider.").category(CATEGORY).subCategory(SUBCATEGORY).index(6).build(), PropertyDefinition.builder((String)USER_LOGIN_ATTRIBUTE).name("SAML user login attribute").description("Attribute defining the user login in SAML.").category(CATEGORY).subCategory(SUBCATEGORY).index(7).build(), PropertyDefinition.builder((String)USER_NAME_ATTRIBUTE).name("SAML user name attribute").description("Attribute defining the user name in SAML.").category(CATEGORY).subCategory(SUBCATEGORY).index(8).build(), PropertyDefinition.builder((String)USER_EMAIL_ATTRIBUTE).name("SAML user email attribute").description("Attribute defining the user email in SAML.").category(CATEGORY).subCategory(SUBCATEGORY).index(9).build(), PropertyDefinition.builder((String)GROUP_NAME_ATTRIBUTE).name("SAML group attribute").description("Attribute defining the user groups in SAML. Users are associated to the default group only if no attribute is defined.").category(CATEGORY).subCategory(SUBCATEGORY).index(10).build());
    }
}

