/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;

@Immutable
public class Credentials {
    private final String login;
    private final String password;

    public Credentials(String login, @Nullable String password) {
        Preconditions.checkArgument((login != null && !login.isEmpty() ? 1 : 0) != 0, (Object)"login must not be null nor empty");
        this.login = login;
        this.password = StringUtils.defaultIfEmpty((String)password, null);
    }

    public String getLogin() {
        return this.login;
    }

    public Optional<String> getPassword() {
        return Optional.ofNullable(this.password);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Credentials that = (Credentials)o;
        return this.login.equals(that.login) && this.password.equals(that.password);
    }

    public int hashCode() {
        return Objects.hash(this.login, this.password);
    }
}

