/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.authentication.IdentityProvider;
import org.sonar.api.server.authentication.UserIdentity;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.alm.ALM;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.user.GroupDto;
import org.sonar.db.user.UserDto;
import org.sonar.db.user.UserGroupDto;
import org.sonar.server.authentication.UserRegistrar;
import org.sonar.server.authentication.UserRegistration;
import org.sonar.server.authentication.event.AuthenticationException;
import org.sonar.server.authentication.exception.EmailAlreadyExistsRedirectionException;
import org.sonar.server.authentication.exception.UpdateLoginRedirectionException;
import org.sonar.server.organization.DefaultOrganization;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.organization.MemberUpdater;
import org.sonar.server.organization.OrganizationFlags;
import org.sonar.server.organization.OrganizationUpdater;
import org.sonar.server.user.ExternalIdentity;
import org.sonar.server.user.NewUser;
import org.sonar.server.user.UpdateUser;
import org.sonar.server.user.UserSession;
import org.sonar.server.user.UserUpdater;
import org.sonar.server.usergroups.DefaultGroupFinder;

public class UserRegistrarImpl
implements UserRegistrar {
    private static final Logger LOGGER = Loggers.get(UserRegistrarImpl.class);
    private final DbClient dbClient;
    private final UserUpdater userUpdater;
    private final DefaultOrganizationProvider defaultOrganizationProvider;
    private final OrganizationFlags organizationFlags;
    private final OrganizationUpdater organizationUpdater;
    private final DefaultGroupFinder defaultGroupFinder;
    private final MemberUpdater memberUpdater;

    public UserRegistrarImpl(DbClient dbClient, UserUpdater userUpdater, DefaultOrganizationProvider defaultOrganizationProvider, OrganizationFlags organizationFlags, OrganizationUpdater organizationUpdater, DefaultGroupFinder defaultGroupFinder, MemberUpdater memberUpdater) {
        this.dbClient = dbClient;
        this.userUpdater = userUpdater;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
        this.organizationFlags = organizationFlags;
        this.organizationUpdater = organizationUpdater;
        this.defaultGroupFinder = defaultGroupFinder;
        this.memberUpdater = memberUpdater;
    }

    @Override
    public UserDto register(UserRegistration registration) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            UserDto userDto = this.getUser(dbSession, registration.getUserIdentity(), registration.getProvider());
            if (userDto == null) {
                UserDto userDto2 = this.registerNewUser(dbSession, null, registration);
                return userDto2;
            }
            if (!userDto.isActive()) {
                UserDto userDto3 = this.registerNewUser(dbSession, userDto, registration);
                return userDto3;
            }
            UserDto userDto4 = this.registerExistingUser(dbSession, userDto, registration);
            return userDto4;
        }
    }

    @CheckForNull
    private UserDto getUser(DbSession dbSession, UserIdentity userIdentity, IdentityProvider provider) {
        UserDto user = this.dbClient.userDao().selectByExternalIdAndIdentityProvider(dbSession, UserRegistrarImpl.getProviderIdOrProviderLogin(userIdentity), provider.getKey());
        if (user != null) {
            return user;
        }
        user = this.dbClient.userDao().selectByExternalLoginAndIdentityProvider(dbSession, userIdentity.getProviderLogin(), provider.getKey());
        if (user != null) {
            return user;
        }
        String login = userIdentity.getLogin();
        if (login == null) {
            return null;
        }
        return this.dbClient.userDao().selectByLogin(dbSession, login);
    }

    private UserDto registerNewUser(DbSession dbSession, @Nullable UserDto disabledUser, UserRegistration authenticatorParameters) {
        Optional<UserDto> otherUserToIndex = this.detectEmailUpdate(dbSession, authenticatorParameters);
        NewUser newUser = UserRegistrarImpl.createNewUser(authenticatorParameters);
        if (disabledUser == null) {
            return this.userUpdater.createAndCommit(dbSession, newUser, this.beforeCommit(dbSession, true, authenticatorParameters), UserRegistrarImpl.toArray(otherUserToIndex));
        }
        return this.userUpdater.reactivateAndCommit(dbSession, disabledUser, newUser, this.beforeCommit(dbSession, true, authenticatorParameters), UserRegistrarImpl.toArray(otherUserToIndex));
    }

    private UserDto registerExistingUser(DbSession dbSession, UserDto userDto, UserRegistration authenticatorParameters) {
        UpdateUser update = new UpdateUser().setEmail(authenticatorParameters.getUserIdentity().getEmail()).setName(authenticatorParameters.getUserIdentity().getName()).setExternalIdentity(new ExternalIdentity(authenticatorParameters.getProvider().getKey(), authenticatorParameters.getUserIdentity().getProviderLogin(), authenticatorParameters.getUserIdentity().getProviderId()));
        String login = authenticatorParameters.getUserIdentity().getLogin();
        if (login != null) {
            update.setLogin(login);
        }
        this.detectLoginUpdate(dbSession, userDto, update, authenticatorParameters);
        Optional<UserDto> otherUserToIndex = this.detectEmailUpdate(dbSession, authenticatorParameters);
        this.userUpdater.updateAndCommit(dbSession, userDto, update, this.beforeCommit(dbSession, false, authenticatorParameters), UserRegistrarImpl.toArray(otherUserToIndex));
        return userDto;
    }

    private Consumer<UserDto> beforeCommit(DbSession dbSession, boolean isNewUser, UserRegistration authenticatorParameters) {
        return user -> {
            this.syncGroups(dbSession, authenticatorParameters.getUserIdentity(), (UserDto)user);
            this.synchronizeOrganizationMembership(dbSession, (UserDto)user, authenticatorParameters, isNewUser);
        };
    }

    private Optional<UserDto> detectEmailUpdate(DbSession dbSession, UserRegistration authenticatorParameters) {
        String email = authenticatorParameters.getUserIdentity().getEmail();
        if (email == null) {
            return Optional.empty();
        }
        List existingUsers = this.dbClient.userDao().selectByEmail(dbSession, email);
        if (existingUsers.isEmpty()) {
            return Optional.empty();
        }
        if (existingUsers.size() > 1) {
            throw UserRegistrarImpl.generateExistingEmailError(authenticatorParameters, email);
        }
        UserDto existingUser = (UserDto)existingUsers.get(0);
        if (existingUser == null || UserRegistrarImpl.isSameUser(existingUser, authenticatorParameters)) {
            return Optional.empty();
        }
        UserRegistration.ExistingEmailStrategy existingEmailStrategy = authenticatorParameters.getExistingEmailStrategy();
        switch (existingEmailStrategy) {
            case ALLOW: {
                existingUser.setEmail(null);
                this.dbClient.userDao().update(dbSession, existingUser);
                return Optional.of(existingUser);
            }
            case WARN: {
                throw new EmailAlreadyExistsRedirectionException(email, existingUser, authenticatorParameters.getUserIdentity(), authenticatorParameters.getProvider());
            }
            case FORBID: {
                throw UserRegistrarImpl.generateExistingEmailError(authenticatorParameters, email);
            }
        }
        throw new IllegalStateException(String.format("Unknown strategy %s", new Object[]{existingEmailStrategy}));
    }

    private static boolean isSameUser(UserDto existingUser, UserRegistration authenticatorParameters) {
        return Objects.equals(existingUser.getLogin(), authenticatorParameters.getUserIdentity().getLogin()) || Objects.equals(existingUser.getExternalIdentityProvider(), authenticatorParameters.getProvider().getKey()) && (Objects.equals(existingUser.getExternalId(), UserRegistrarImpl.getProviderIdOrProviderLogin(authenticatorParameters.getUserIdentity())) || Objects.equals(existingUser.getExternalLogin(), authenticatorParameters.getUserIdentity().getProviderLogin()));
    }

    private void detectLoginUpdate(DbSession dbSession, UserDto user, UpdateUser update, UserRegistration authenticatorParameters) {
        String newLogin = update.login();
        if (!update.isLoginChanged() || user.getLogin().equals(newLogin)) {
            return;
        }
        if (!this.organizationFlags.isEnabled(dbSession)) {
            return;
        }
        String personalOrganizationUuid = user.getOrganizationUuid();
        if (personalOrganizationUuid == null) {
            return;
        }
        Optional personalOrganization = this.dbClient.organizationDao().selectByUuid(dbSession, personalOrganizationUuid);
        Preconditions.checkState((boolean)personalOrganization.isPresent(), (String)"Cannot find personal organization uuid '%s' for user '%s'", (Object[])new Object[]{personalOrganizationUuid, user.getLogin()});
        UserRegistration.UpdateLoginStrategy updateLoginStrategy = authenticatorParameters.getUpdateLoginStrategy();
        switch (updateLoginStrategy) {
            case ALLOW: {
                this.organizationUpdater.updateOrganizationKey(dbSession, (OrganizationDto)personalOrganization.get(), Objects.requireNonNull(newLogin, "new login cannot be null"));
                return;
            }
            case WARN: {
                throw new UpdateLoginRedirectionException(authenticatorParameters.getUserIdentity(), authenticatorParameters.getProvider(), user, (OrganizationDto)personalOrganization.get());
            }
        }
        throw new IllegalStateException(String.format("Unknown strategy %s", new Object[]{updateLoginStrategy}));
    }

    private void syncGroups(DbSession dbSession, UserIdentity userIdentity, UserDto userDto) {
        if (!userIdentity.shouldSyncGroups()) {
            return;
        }
        String userLogin = userDto.getLogin();
        HashSet userGroups = new HashSet(this.dbClient.groupMembershipDao().selectGroupsByLogins(dbSession, Collections.singletonList(userLogin)).get((Object)userLogin));
        Set identityGroups = userIdentity.getGroups();
        LOGGER.debug("List of groups returned by the identity provider '{}'", (Object)identityGroups);
        Sets.SetView groupsToAdd = Sets.difference((Set)identityGroups, userGroups);
        Sets.SetView groupsToRemove = Sets.difference(userGroups, (Set)identityGroups);
        ArrayList allGroups = new ArrayList(groupsToAdd);
        allGroups.addAll(groupsToRemove);
        DefaultOrganization defaultOrganization = this.defaultOrganizationProvider.get();
        Map groupsByName = (Map)this.dbClient.groupDao().selectByNames(dbSession, defaultOrganization.getUuid(), allGroups).stream().collect(MoreCollectors.uniqueIndex(GroupDto::getName));
        this.addGroups(dbSession, userDto, (Collection<String>)groupsToAdd, groupsByName);
        this.removeGroups(dbSession, userDto, (Collection<String>)groupsToRemove, groupsByName);
    }

    private void addGroups(DbSession dbSession, UserDto userDto, Collection<String> groupsToAdd, Map<String, GroupDto> groupsByName) {
        groupsToAdd.stream().map(groupsByName::get).filter(Objects::nonNull).forEach(groupDto -> {
            LOGGER.debug("Adding group '{}' to user '{}'", (Object)groupDto.getName(), (Object)userDto.getLogin());
            this.dbClient.userGroupDao().insert(dbSession, new UserGroupDto().setGroupId(groupDto.getId().intValue()).setUserId(userDto.getId().intValue()));
        });
    }

    private void removeGroups(DbSession dbSession, UserDto userDto, Collection<String> groupsToRemove, Map<String, GroupDto> groupsByName) {
        Optional<GroupDto> defaultGroup = this.getDefaultGroup(dbSession);
        groupsToRemove.stream().map(groupsByName::get).filter(Objects::nonNull).filter(group -> !defaultGroup.isPresent() || !group.getId().equals(((GroupDto)defaultGroup.get()).getId())).forEach(groupDto -> {
            LOGGER.debug("Removing group '{}' from user '{}'", (Object)groupDto.getName(), (Object)userDto.getLogin());
            this.dbClient.userGroupDao().delete(dbSession, groupDto.getId().intValue(), userDto.getId().intValue());
        });
    }

    private Optional<GroupDto> getDefaultGroup(DbSession dbSession) {
        return this.organizationFlags.isEnabled(dbSession) ? Optional.empty() : Optional.of(this.defaultGroupFinder.findDefaultGroup(dbSession, this.defaultOrganizationProvider.get().getUuid()));
    }

    private void synchronizeOrganizationMembership(DbSession dbSession, UserDto userDto, UserRegistration authenticatorParameters, boolean isNewUser) {
        Set<String> almOrganizationIds = authenticatorParameters.getOrganizationAlmIds();
        if (almOrganizationIds == null || !isNewUser || !this.organizationFlags.isEnabled(dbSession)) {
            return;
        }
        UserSession.IdentityProvider identityProvider = UserSession.IdentityProvider.getFromKey(authenticatorParameters.getProvider().getKey());
        if (identityProvider != UserSession.IdentityProvider.GITHUB) {
            return;
        }
        this.memberUpdater.synchronizeUserOrganizationMembership(dbSession, userDto, ALM.GITHUB, almOrganizationIds);
    }

    private static NewUser createNewUser(UserRegistration authenticatorParameters) {
        String identityProviderKey = authenticatorParameters.getProvider().getKey();
        if (!authenticatorParameters.getProvider().allowsUsersToSignUp()) {
            throw AuthenticationException.newBuilder().setSource(authenticatorParameters.getSource()).setLogin(authenticatorParameters.getUserIdentity().getProviderLogin()).setMessage(String.format("User signup disabled for provider '%s'", identityProviderKey)).setPublicMessage(String.format("'%s' users are not allowed to sign up", identityProviderKey)).build();
        }
        return NewUser.builder().setLogin(authenticatorParameters.getUserIdentity().getLogin()).setEmail(authenticatorParameters.getUserIdentity().getEmail()).setName(authenticatorParameters.getUserIdentity().getName()).setExternalIdentity(new ExternalIdentity(identityProviderKey, authenticatorParameters.getUserIdentity().getProviderLogin(), authenticatorParameters.getUserIdentity().getProviderId())).build();
    }

    /*
     * Exception decompiling
     */
    private static UserDto[] toArray(Optional<UserDto> userDto) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static AuthenticationException generateExistingEmailError(UserRegistration authenticatorParameters, String email) {
        return AuthenticationException.newBuilder().setSource(authenticatorParameters.getSource()).setLogin(authenticatorParameters.getUserIdentity().getProviderLogin()).setMessage(String.format("Email '%s' is already used", email)).setPublicMessage(String.format("You can't sign up because email '%s' is already used by an existing user. This means that you probably already registered with another account.", email)).build();
    }

    private static String getProviderIdOrProviderLogin(UserIdentity userIdentity) {
        String providerId = userIdentity.getProviderId();
        return providerId == null ? userIdentity.getProviderLogin() : providerId;
    }
}

