/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.organization.ws;

import com.google.common.base.Strings;
import com.google.protobuf.Message;
import java.util.Optional;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.user.GroupMembershipQuery;
import org.sonar.db.user.UserDto;
import org.sonar.server.issue.ws.AvatarResolver;
import org.sonar.server.organization.MemberUpdater;
import org.sonar.server.organization.ws.OrganizationsWsAction;
import org.sonar.server.organization.ws.OrganizationsWsSupport;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Organizations;

public class AddMemberAction
implements OrganizationsWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final AvatarResolver avatarResolver;
    private final OrganizationsWsSupport wsSupport;
    private final MemberUpdater memberUpdater;

    public AddMemberAction(DbClient dbClient, UserSession userSession, AvatarResolver avatarResolver, OrganizationsWsSupport wsSupport, MemberUpdater memberUpdater) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.avatarResolver = avatarResolver;
        this.wsSupport = wsSupport;
        this.memberUpdater = memberUpdater;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("add_member").setDescription("Add a user as a member of an organization.<br>Requires 'Administer System' permission on the specified organization.").setSince("6.4").setPost(true).setInternal(true).setResponseExample(this.getClass().getResource("add_member-example.json")).setHandler((RequestHandler)this);
        action.createParam("organization").setDescription("Organization key").setRequired(true).setExampleValue((Object)"my-org");
        action.createParam("login").setDescription("User login").setRequired(true).setExampleValue((Object)"ray.bradbury");
    }

    public void handle(Request request, Response response) throws Exception {
        String organizationKey = request.mandatoryParam("organization");
        String login = request.mandatoryParam("login");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = (OrganizationDto)WsUtils.checkFoundWithOptional(this.dbClient.organizationDao().selectByKey(dbSession, organizationKey), "Organization '%s' is not found", organizationKey);
            this.userSession.checkPermission(OrganizationPermission.ADMINISTER, organization);
            this.wsSupport.checkMemberSyncIsDisabled(dbSession, organization);
            UserDto user = WsUtils.checkFound(this.dbClient.userDao().selectByLogin(dbSession, login), "User '%s' is not found", login);
            this.memberUpdater.addMember(dbSession, organization, user);
            int groups = this.dbClient.groupMembershipDao().countGroups(dbSession, GroupMembershipQuery.builder().organizationUuid(organization.getUuid()).membership("IN").build(), user.getId());
            Organizations.AddMemberWsResponse wsResponse = this.buildResponse(user, groups);
            WsUtils.writeProtobuf((Message)wsResponse, request, response);
        }
    }

    private Organizations.AddMemberWsResponse buildResponse(UserDto user, int groups) {
        Organizations.AddMemberWsResponse.Builder response = Organizations.AddMemberWsResponse.newBuilder();
        Organizations.User.Builder wsUser = Organizations.User.newBuilder().setLogin(user.getLogin()).setName(user.getName()).setGroupCount(groups);
        Optional.ofNullable(Strings.emptyToNull((String)user.getEmail())).ifPresent(text -> wsUser.setAvatar(this.avatarResolver.create(user)));
        response.setUser(wsUser);
        return response.build();
    }
}

