/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.organization.ws;

import java.util.Objects;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.organization.OrganisationSupport;
import org.sonar.server.organization.ws.OrganizationsWsAction;
import org.sonar.server.user.UserSession;

public class EnableSupportAction
implements OrganizationsWsAction {
    private static final String ACTION = "enable_support";
    private final UserSession userSession;
    private final DefaultOrganizationProvider defaultOrganizationProvider;
    private final OrganisationSupport organisationSupport;

    public EnableSupportAction(UserSession userSession, DefaultOrganizationProvider defaultOrganizationProvider, OrganisationSupport organisationSupport) {
        this.userSession = userSession;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
        this.organisationSupport = organisationSupport;
    }

    public void define(WebService.NewController context) {
        context.createAction(ACTION).setPost(true).setDescription("Enable support of organizations.<br />'Administer System' permission is required. The logged-in user will be flagged as root and will be able to manage organizations and other root users.").setInternal(true).setPost(true).setSince("6.3").setChangelog(new Change[]{new Change("6.4", "Create default 'Members' group")}).setHandler((RequestHandler)this);
    }

    public void handle(Request request, Response response) throws Exception {
        this.verifySystemAdministrator();
        this.organisationSupport.enable(Objects.requireNonNull(this.userSession.getLogin()));
        response.noContent();
    }

    private void verifySystemAdministrator() {
        this.userSession.checkLoggedIn().checkPermission(OrganizationPermission.ADMINISTER, this.defaultOrganizationProvider.get().getUuid());
    }
}

