/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.organization.ws;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.user.UserDto;
import org.sonar.server.organization.MemberUpdater;
import org.sonar.server.organization.ws.OrganizationsWsAction;
import org.sonar.server.organization.ws.OrganizationsWsSupport;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

public class RemoveMemberAction
implements OrganizationsWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final OrganizationsWsSupport wsSupport;
    private final MemberUpdater memberUpdater;

    public RemoveMemberAction(DbClient dbClient, UserSession userSession, OrganizationsWsSupport wsSupport, MemberUpdater memberUpdater) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.wsSupport = wsSupport;
        this.memberUpdater = memberUpdater;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("remove_member").setDescription("Remove a member from an organization.<br>Requires 'Administer System' permission on the specified organization.").setSince("6.4").setPost(true).setInternal(true).setHandler((RequestHandler)this);
        action.createParam("organization").setDescription("Organization key").setRequired(true).setExampleValue((Object)"my-org");
        action.createParam("login").setDescription("User login").setRequired(true).setExampleValue((Object)"ray.bradbury");
    }

    public void handle(Request request, Response response) throws Exception {
        String organizationKey = request.mandatoryParam("organization");
        String login = request.mandatoryParam("login");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = (OrganizationDto)WsUtils.checkFoundWithOptional(this.dbClient.organizationDao().selectByKey(dbSession, organizationKey), "Organization '%s' is not found", organizationKey);
            this.userSession.checkPermission(OrganizationPermission.ADMINISTER, organization);
            this.wsSupport.checkMemberSyncIsDisabled(dbSession, organization);
            UserDto user = WsUtils.checkFound(this.dbClient.userDao().selectActiveUserByLogin(dbSession, login), "User '%s' is not found", login);
            this.memberUpdater.removeMember(dbSession, organization, user);
        }
        response.noContent();
    }
}

